/*
 *  GameApp.h
 *  SDLTextureLoad
 *
 *  Created by Mark Szymczyk on 6/6/06.
 *  Copyright 2006 Me and Mark Publishing. All rights reserved.
 *
 */

#include "SDL.h"
#include "SDL_OpenGL.h"
#include "SDL_image.h"

#ifndef GAME_TEXTURE
    #include "GameTexture.h"
#endif

class GameApp
{
    protected:
        SDL_TimerID timer;
        bool done;
        GameTexture textureMap;
    
    public:
        // Constructor and destructor
        GameApp (void);
        virtual ~GameApp(void);
    
        // Initialization functions
        void InitApp(void);
        void InitializeSDL(void);
        void InstallTimer(void);
        static Uint32 GameLoopTimer(Uint32 interval, void* param);
    
        // Cleanup functions
        void Cleanup(void);
    
        // Event-related functions
        void EventLoop(void);
        void HandleUserEvents(SDL_Event* event);
    
        // Game related functions
        void GameLoop(void);
        void RenderFrame(void);
    
};

typedef GameApp* GameAppPtr;
typedef GameApp** GameAppHandle;

const int RUN_GAME_LOOP = 1;