/*
 *  GameApp.cpp
 *  SDLTextureLoad
 *
 *  Created by Mark Szymczyk on 6/6/06.
 *  Copyright 2006 Me and Mark Publishing. All rights reserved.
 *
 */

#include "GameApp.h"

// Constructor
GameApp::GameApp(void)
{
    done = false;
}

// Destructor
GameApp::~GameApp(void)
{
    
}


// Initialization functions
void GameApp::InitApp(void)
{
    InitializeSDL();
    InstallTimer();
    
    textureMap.SetInternalFormat(GL_RGBA8);
    
    // The call to QTNewGWorldFromPtr() requires a
    // 32-bit ARGB pixel format for 32-bit color. There
    // is no GL_ARGB format so we must use GL_BGRA and
    // reverse the values on big-endian systems.
    textureMap.SetFormat(GL_RGBA); //(GL_BGRA);
    
    #if __BIG_ENDIAN__
        textureMap.SetType(GL_UNSIGNED_INT_8_8_8_8);//(GL_UNSIGNED_INT_8_8_8_8_REV);
    #else
        textureMap.SetType(GL_UNSIGNED_INT_8_8_8_8_REV);//(GL_UNSIGNED_INT_8_8_8_8);
    #endif

    // Look in the application bundle for the background texture file on Mac OS X.
    // Look in the directory where the executable file resides on other operating systems.
    #if __MACOSX__
        textureMap.Load("SDLTextureLoad.app/Contents/Resources/Background.png");
    #else
        textureMap.Load("Background.png");
    #endif

}

void GameApp::InitializeSDL(void)
{
    int error;
    SDL_Surface* drawContext;
    
    error = SDL_Init(SDL_INIT_EVERYTHING);
    
    // Create a double-buffered draw context
    SDL_GL_SetAttribute(SDL_GL_DOUBLEBUFFER, 1);

    // Use 32-bit color: 8 bits of red, green, blue, and alpha.
    SDL_GL_SetAttribute(SDL_GL_RED_SIZE, 8);
    SDL_GL_SetAttribute(SDL_GL_GREEN_SIZE, 8);
    SDL_GL_SetAttribute(SDL_GL_BLUE_SIZE, 8);
    SDL_GL_SetAttribute(SDL_GL_ALPHA_SIZE, 8);
    
    Uint32 flags;
    flags = SDL_OPENGL;// | SDL_FULLSCREEN;
    drawContext = SDL_SetVideoMode(640, 480, 0, flags);
        
    gluOrtho2D(0.0, 4.0, 0.0, 3.0);
        
}

void GameApp::InstallTimer(void)
{
    timer = SDL_AddTimer(30, GameLoopTimer, this);
}

Uint32 GameApp::GameLoopTimer(Uint32 interval, void* param)
{
    //GameAppPtr currentApp = (GameAppPtr)param;
    
    //currentApp->GameLoop();
    
    // Create a user event to call the game loop.
    SDL_Event event;
    
    event.type = SDL_USEREVENT;
    event.user.code = RUN_GAME_LOOP;
    event.user.data1 = 0;
    event.user.data2 = 0;
    
    SDL_PushEvent(&event);
    
    return interval;
}


// Cleanup functions
void GameApp::Cleanup(void)
{
    SDL_bool success;
    success = SDL_RemoveTimer(timer);
    
    SDL_Quit();
}

// Event-related functions
void GameApp::EventLoop(void)
{
    SDL_Event event;
    
    while((!done) && (SDL_WaitEvent(&event))) {
        switch(event.type) {
            case SDL_USEREVENT:
                HandleUserEvents(&event);
                break;
                
            case SDL_KEYDOWN:
                done = true;
                break;
                
            case SDL_QUIT:
                done = true;
                break;
                
            default:
                break;
        }   // End switch
        
    }   // End while
    
}

void GameApp::HandleUserEvents(SDL_Event* event)
{
    switch (event->user.code) {
        case RUN_GAME_LOOP:
            GameLoop();
            break;
            
        default:
            break;
    }
}

// Game related functions
void GameApp::GameLoop(void)
{
    RenderFrame();    
}

void GameApp::RenderFrame(void) 
{
    glClear(GL_COLOR_BUFFER_BIT);
    textureMap.Draw();    
    SDL_GL_SwapBuffers();
}
