/*
 *  InputController.h
 *  SDLGame
 *
 *  Created by Mark Szymczyk on 10/25/06.
 *  Copyright 2006 Me and Mark Publishing. All rights reserved.
 *
 */

#include "SDL.h"

class InputController
{
    protected:
        SDL_Joystick* joystick;
        Uint8* keymap;      // Only used if reading the keyboard manually
        Sint8 xAxisValue;
        Sint8 yAxisValue;
        Sint16 rotationXValue;
        
    public:
        // Constructor and destructor
        InputController(void);
        virtual ~InputController(void);
        
        // Accessors
        SDL_Joystick* GetJoystick(void);
        void SetJoystick(SDL_Joystick* theStick);

        Uint8* GetKeymap(void);
        void SetKeymap(Uint8* theMap);

        Sint8 GetXAxisValue(void);
        void SetXAxisValue(Sint8 axisValue);
        
        Sint8 GetYAxisValue(void);
        void SetYAxisValue(Sint8 axisValue);

        Sint16 GetRotationXValue(void);
        void SetRotationXValue(Sint16 rotationValue);

        // Event handling functions
        void HandleKeyPress(SDL_Event* event);
        void HandleKeyUp(SDL_Event* event);
        void HandleMouseMovement(SDL_Event* event);
        void HandleMouseClick(SDL_Event* event);
        void HandleMouseButtonUp(SDL_Event* event);
        void HandleJoystickAxisMovement(SDL_Event* event);
        void HandleJoystickButtonPress(SDL_Event* event);
        void HandleJoystickButtonUp(SDL_Event* event);
 
        // Functions to read the keyboard manually
        void ReadKeyboard(void);
        
        // Functions to read the mouse manually
        void ReadMouse(void);
        void ReadMouseRelative(void);
        
        // Functions to read the joystick manually
        void ReadJoystick(void);
        bool WasButtonPressed(int button);

        // Utility functions
        Sint8 ScaleAxisValue(Sint16 rawAxisValue, Sint16 minRawValue, Sint16 maxRawValue,
                             Sint8 minScaledValue, Sint8 maxScaledValue);
        
};

typedef InputController* InputControllerPtr;
typedef InputController** InputControllerHandle;

const Uint8 X_AXIS = 0;
const Uint8 Y_AXIS = 1;
const Sint16 POSITIVE_DEAD_ZONE = 6400;
const Sint16 NEGATIVE_DEAD_ZONE = -6400;
const Sint16 MAX_RAW_AXIS_VALUE = 32767;
const Sint16 MIN_RAW_AXIS_VALUE = -32768;
const Sint8 MAX_X_AXIS_VALUE = 5;
const Sint8 MIN_X_AXIS_VALUE = -5;
const Sint8 MAX_Y_AXIS_VALUE = 5;
const Sint8 MIN_Y_AXIS_VALUE = -5; 
const Sint8 AXIS_CENTERED = 0;


// Degrees for orientation in eight directions
const float FACING_EAST = 0.0f;
const float FACING_NORTHEAST = 45.0f;
const float FACING_NORTH = 90.0f;
const float FACING_NORTHWEST = 135.0f;
const float FACING_WEST = 180.0f;
const float FACING_SOUTHWEST = 225.0f;
const float FACING_SOUTH = 270.0f;
const float FACING_SOUTHEAST = 315.0f;
        
        
        