/*
 *  GameSprite.h
 *  SDLGame
 *
 *  Created by Mark Szymczyk on 6/22/06.
 *  Copyright 2006 Me and Mark Publishing. All rights reserved.
 *
 */

#define GAME_SPRITE

class GameSprite
{
    protected:
        float worldX;
        float worldY;
    
        float width;    // in world units
        float height;   // in world units
        
        // Direction the sprite is facing.
        float orientation;  // in degrees
    
    public:
        // Constructor and destructor
        GameSprite();
        virtual ~GameSprite(void);
    
        // Accessor functions
        float GetWorldX(void);
        void SetWorldX(float x);
    
        float GetWorldY(void);
        void SetWorldY(float y);
    
        float GetWidth(void);
        void SetWidth(float theWidth);
        
        float GetHeight(void);
        void SetHeight(float theHeight);
        
        float GetOrientation(void);
        void SetOrientation(float orientationValue);
    
        // Movement related functions. I will remove them
        // when I implement physics.
        virtual void Move(void);
        //void MoveLeft(float distance);
        //void MoveRight(float distance);
        //void MoveUp(float distance);
        //void MoveDown(float distance);
        
};

typedef GameSprite* GameSpritePtr;
typedef GameSprite** GameSpriteHandle;
