/*
 *  GameSound.h
 *  SDLGame
 *
 *  Created by Mark Szymczyk on 7/1/06.
 *  Copyright 2006 Me and Mark Publishing. All rights reserved.
 *
 */

#include "SDL.h"

#if __MACOSX__
    // I have no idea why I can just include SDL_image.h, but can't
    // just include SDL_mixer.h so I have to include SDL_mixer/SDL_mixer.h
    #include "SDL_mixer/SDL_mixer.h"
#else
    #include "SDL_mixer.h"
#endif

#define GAME_SOUND

class GameSound
{
    protected:
        Mix_Chunk* soundData;
        int channel;
    
    public:
        // Constructor 
        GameSound(void);
    
        // Destructor
        virtual ~GameSound(void);
    
        // Accessors
        Mix_Chunk* GetSoundData(void);
        void SetSoundData(Mix_Chunk* theData);
    
        int GetChannel(void);
        void SetChannel(int theChannel);
    
        // File related functions
        void Load(char* filename);
    
        // Playback related functions
        void Play(int timesToPlay);
        void PlayWithFadeIn(int timesToPlay, int fadeInTime);
        void PlayRepeatedly(void);
        void PlayRepeatedlyWithFadeIn(int fadeInTime);
        void PlayForPeriodOfTime(int duration);
        void PlayForPeriodOfTimeWithFadeIn(int duration, int fadeInTime);
        void FadeOut(int fadeOutTime);
        void Pause(void);
        void Resume(void);
        void Stop(void);
    
};

typedef GameSound* GameSoundPtr;
typedef GameSound** GameSoundHandle;
