/*
 *  GameSound.cpp
 *  SDLGame
 *
 *  Created by Mark Szymczyk on 7/1/06.
 *  Copyright 2006 Me and Mark Publishing. All rights reserved.
 *
 */

#include "GameSound.h"

// Constructor and destructor
GameSound::GameSound(void)
{
    soundData = NULL;
    
    // Set channel initially to -1. This will tell SDL_mixer to find the first
    // free channel the first time you play a sound.
    channel = -1;
}

GameSound::~GameSound(void)
{
    
}


// Accessors
Mix_Chunk* GameSound::GetSoundData(void)
{
    return soundData;
}

void GameSound::SetSoundData(Mix_Chunk* theData)
{
    soundData = theData;
}

int GameSound::GetChannel(void)
{
    return channel;
}

void GameSound::SetChannel(int theChannel)
{
    channel = theChannel;
}


// File related functions
void GameSound::Load(char* filename)
{
    soundData = Mix_LoadWAV(filename);
}


// Playback related functions
void GameSound::Play(int timesToPlay)
{
    // The third parameter is the number of loops. The number of times
    // the sound will play is (loops + 1).
    // That's why I have to supply the value (timesToPlay - 1).
    channel = Mix_PlayChannel(channel, soundData, timesToPlay - 1);
}

void GameSound::PlayWithFadeIn(int timesToPlay, int fadeInTime)
{
    // fadeInTime (in milliseconds) is the amount of time it takes
    // to go from 0 volume to the sound's full volume.
    
    channel = Mix_FadeInChannel(channel, soundData, (timesToPlay - 1), fadeInTime);
}

void GameSound::PlayRepeatedly(void)
{
    // The -1 tells SDL_mixer to play the sound repeatedly.
    channel = Mix_PlayChannel(channel, soundData, -1);
}

void GameSound::PlayRepeatedlyWithFadeIn(int fadeInTime)
{
    // fadeInTime (in milliseconds) is the amount of time it takes
    // to go from 0 volume to the sound's full volume.
    
    channel = Mix_FadeInChannel(channel, soundData, -1, fadeInTime);
}

void GameSound::PlayForPeriodOfTime(int duration)
{
    // duration is specified in milliseconds.
    
    // The -1 tells SDL_mixer to play the sound as many times
    // as needed until the time limit is reached.
    channel = Mix_PlayChannelTimed(channel, soundData, -1, duration);
}

void GameSound::PlayForPeriodOfTimeWithFadeIn(int duration, int fadeInTime)
{
    // duration and fadeInTime are specified in milliseconds.
    
    // The -1 tells SDL_mixer to play the sound as many times
    // as needed until the time limit is reached.
    channel = Mix_FadeInChannelTimed(channel, soundData, -1, fadeInTime, duration);
}

void GameSound::FadeOut(int fadeOutTime)
{
    // fadeOutTime (in milliseconds) is the amount of time it takes
    // to go from full volume to silence.
    int channelsToFade;
    channelsToFade = Mix_FadeOutChannel(channel, fadeOutTime);        
}

void GameSound::Pause(void)
{
    Mix_Pause(channel);
}

void GameSound::Resume(void)
{
    Mix_Resume(channel);
}

void GameSound::Stop(void)
{
    Mix_HaltChannel(channel);
}
