/*
 *  GameSong.h
 *  SDLGame
 *
 *  Created by Mark Szymczyk on 6/30/06.
 *  Copyright 2006 Me and Mark Publishing. All rights reserved.
 *
 */

#include "SDL.h"

#if __MACOSX__
    // I have no idea why I can just include SDL_image.h, but can't
    // just include SDL_mixer.h so I have to include SDL_mixer/SDL_mixer.h
    #include "SDL_mixer/SDL_mixer.h"
#else
    #include "SDL_mixer.h"
#endif

#define GAME_SONG

class GameSong
{
    protected:
        Mix_Music* songData;
    
    public:
        // Constructor 
        GameSong(void);
    
        // Destructor
        virtual ~GameSong(void);
        
        // Accessors
        Mix_Music* GetSongData(void);
        void SetSongData(Mix_Music* theData);
        
        // File related functions
        void Load(char* filename);
        
        // Playback related functions
        void Play(int timesToPlay);
        void PlayWithFadeIn(int timesToPlay, int fadeInTime);
        void PlayRepeatedly(void);
        void PlayRepeatedlyWithFadeIn(int fadeInTime);
        void FadeOut(int fadeOutTime);
        void Pause(void);
        void Resume(void);
        void Stop(void);
        
};

typedef GameSong* GameSongPtr;
typedef GameSong** GameSongHandle;
    
        