/*
 *  GameSong.cpp
 *  SDLGame
 *
 *  Created by Mark Szymczyk on 6/30/06.
 *  Copyright 2006 Me and Mark Publishing. All rights reserved.
 *
 */

#include "GameSong.h"

// Constructor and destructor
GameSong::GameSong(void)
{
    songData = NULL;
}

GameSong::~GameSong(void)
{
    
}


// Accessors
Mix_Music* GameSong::GetSongData(void)
{
    return songData;
}

void GameSong::SetSongData(Mix_Music* theData)
{
    songData = theData;
}

// File related functions
void GameSong::Load(char* filename)
{
    songData = Mix_LoadMUS(filename);
}

// Playback related functions
void GameSong::Play(int timesToPlay)
{
    int success;
    success = Mix_PlayMusic(songData, timesToPlay);
}

void GameSong::PlayWithFadeIn(int timesToPlay, int fadeInTime)
{
    // fadeInTime (in milliseconds) is the amount of time it takes
    // to go from 0 volume to the sound's full volume.
    int success;
    success= Mix_FadeInMusic(songData, timesToPlay, fadeInTime);
}

void GameSong::PlayRepeatedly(void)
{
    int success;
    // The -1 tells SDL_mixer to play the song repeatedly.
    success = Mix_PlayMusic(songData, -1);    
}

void GameSong::PlayRepeatedlyWithFadeIn(int fadeInTime)
{
    // fadeInTime (in milliseconds) is the amount of time it takes
    // to go from 0 volume to the sound's full volume.
    
    int success;
    // The -1 tells SDL_mixer to play the song repeatedly.
    success = Mix_FadeInMusic(songData, -1, fadeInTime);
}

void GameSong::FadeOut(int fadeOutTime)
{
    // fadeOutTime (in milliseconds) is the amount of time it takes
    // to go from full volume to silence.
    int success;
    success = Mix_FadeOutMusic(fadeOutTime);
}

void GameSong::Pause(void)
{
    Mix_PauseMusic();
}

void GameSong::Resume(void)
{
    Mix_ResumeMusic();
}

void GameSong::Stop(void)
{
    Mix_HaltMusic();
}
