/*
 *  GamePlayer.h
 *  SDLGame
 *
 *  Created by Mark Szymczyk on 11/6/06.
 *  Copyright 2006 Me and Mark Publishing. All rights reserved.
 *
 */

#ifndef INPUT_CONTROLLER
    #include "InputController.h"
#endif

#ifndef GAME_SPRITE
    #include "GameSprite.h"
#endif

#define GAME_PLAYER

class GamePlayer : public GameSprite
{
    protected:
        InputControllerPtr playerController;
    
    public:
        // Constructor and destructor
        GamePlayer();
        ~GamePlayer();
    
        // Accessor functions
        InputControllerPtr GetPlayerController(void);
        void SetPlayerController(InputControllerPtr theController);
        
        // Functions to override from GameSprite class
        virtual void Move(void);
};

typedef GamePlayer* GamePlayerPtr;
typedef GamePlayer** GamePlayerHandle;

        