/*
 *  GamePlayer.cpp
 *  SDLGame
 *
 *  Created by Mark Szymczyk on 11/6/06.
 *  Copyright 2006 Me and Mark Publishing. All rights reserved.
 *
 */

#include "GamePlayer.h"

// Constructor
GamePlayer::GamePlayer(void)
{
    playerController = new InputController;
}

// Destructor
GamePlayer::~GamePlayer(void)
{
    delete playerController;
}

// Accessors
InputControllerPtr GamePlayer::GetPlayerController(void)
{
    return playerController;
}

void GamePlayer::SetPlayerController(InputControllerPtr theController)
{
    playerController = theController;
}

// Functions to override from GameSprite class
void GamePlayer::Move(void)
{
    float xDistance = playerController->GetXAxisValue();
    float yDistance = playerController->GetYAxisValue();
    
    worldX = worldX + xDistance;
    worldY = worldY + yDistance;
    
    // Set the orientation
    if ((xDistance > AXIS_CENTERED) && (yDistance > AXIS_CENTERED))
        SetOrientation(FACING_NORTHEAST);
    else if ((xDistance > AXIS_CENTERED) && (yDistance < AXIS_CENTERED))
        SetOrientation(FACING_SOUTHEAST);
    else if ((xDistance < AXIS_CENTERED) && (yDistance > AXIS_CENTERED))
        SetOrientation(FACING_NORTHWEST);
    else if ((xDistance < AXIS_CENTERED) && (yDistance < AXIS_CENTERED))
        SetOrientation(FACING_SOUTHWEST);
    // At this point we know the player did not move diagnoally
    else if (xDistance > AXIS_CENTERED)
        SetOrientation(FACING_EAST);
    else if (xDistance < AXIS_CENTERED)
        SetOrientation(FACING_WEST);
    else if (yDistance > AXIS_CENTERED)
        SetOrientation(FACING_NORTH);
    else if (yDistance < AXIS_CENTERED)
        SetOrientation(FACING_SOUTH);

    Sint16 rotation = playerController->GetRotationXValue();
    float newOrientation;
    
    // Rotate left
    if (rotation < 0) {
        newOrientation = GetOrientation() + 5.0f;
        if (newOrientation >= 360.0)
            newOrientation = 0.0f;
        SetOrientation(newOrientation);
    }

    // Rotate right
    if (rotation > 0) {
        newOrientation = GetOrientation() - 5.0f;
        if (newOrientation <= 0.0)
            newOrientation = 360.0f;
        SetOrientation(newOrientation);
    }
    
    // Set the rotation back to 0 because we don't get an event when the user stops moving the mouse.
    // Without setting the rotation, the player's ship rotates by itself.
    playerController->SetRotationXValue(0.0);
}
