/*
 *  GameApp.h
 *  SDLGame
 *
 *  Created by Mark Szymczyk on 6/12/06.
 *  Copyright 2006 Me and Mark Publishing. All rights reserved.
 *
 */

#include "SDL.h"
#include "SDL_OpenGL.h"
#include "SDL_image.h"

#ifndef GAME_CONTEXT
    #include "GameContext.h"
#endif

#ifndef GAME_SPRITE
    #include "GameSprite.h"
#endif

#ifndef GAME_PLAYER
    #include "GamePlayer.h"
#endif

#ifndef GAME_SONG
    #include "GameSong.h"
#endif

#ifndef GAME_SOUND
    #include "GameSound.h"
#endif

class GameApp
{
    protected:
        SDL_TimerID timer;
        bool done;
        GameContext context;
        GamePlayer player1;
        GameSong backgroundMusic;
        GameSound soundEffect;
    
    public:
        // Constructor and destructor
        GameApp (void);
        virtual ~GameApp(void);

        // Accessors
        GameContext GetContext(void);
        void SetContext(GameContext theContext);

        GamePlayer GetPlayer1(void);
        void SetPlayer1(GamePlayer thePlayer);

        // Initialization functions
        void InitApp(void);
        void InitializeSDL(void);
        void InitializeDrawContext(Uint16 width, Uint16 height);
        void InstallTimer(void);
        static Uint32 GameLoopTimer(Uint32 interval, void* param);
    
        // Cleanup functions
        void Cleanup(void);
    
        // Event-related functions
        void EventLoop(void);
        void HandleUserEvents(SDL_Event* event);
    
        // Game related functions
        void GameLoop(void);
        
        // Drawing functions
        void RenderFrame(void);
};

typedef GameApp* GameAppPtr;
typedef GameApp** GameAppHandle;

const int RUN_GAME_LOOP = 1;
