/*
 *  GameApp.cpp
 *  SDLGame
 *
 *  Created by Mark Szymczyk on 6/12/06.
 *  Copyright 2006 Me and Mark Publishing. All rights reserved.
 *
 */

#include "GameApp.h"

// Constructor
GameApp::GameApp(void)
{
    done = false;
}

// Destructor
GameApp::~GameApp(void)
{

}


// Accessors
GameContext GameApp::GetContext(void)
{
    return context;
}

void GameApp::SetContext(GameContext theContext)
{
    context = theContext;
}

GamePlayer GameApp::GetPlayer1(void)
{
    return player1;
}

void GameApp::SetPlayer1(GamePlayer thePlayer)
{
    player1 = thePlayer;
}


// Initialization functions
void GameApp::InitApp(void)
{
    InitializeSDL();
    InitializeDrawContext(640, 480);
    InstallTimer();
    
    //player1 = new GamePlayer;
    player1.SetWorldX(320.0);
    player1.SetWorldY(240.0);
    player1.SetWidth(64.0);
    player1.SetHeight(64.0);
    player1.SetOrientation(0.0);

    int state;
    state = SDL_JoystickEventState(SDL_ENABLE); 
    
    SDL_Joystick* joystick1;
    joystick1 = SDL_JoystickOpen(0);
    
    InputControllerPtr controller = player1.GetPlayerController();
    controller->SetJoystick(joystick1);
    
    int success;
    success = Mix_OpenAudio(44100, MIX_DEFAULT_FORMAT, 2, 4096);
    
    /*
	backgroundMusic = new GameSong;
    if (backgroundMusic == NULL)
        done = true;
	*/
	
    // Look in the application bundle for the music file on Mac OS X.
    // Look in the directory where the executable file resides on other operating systems.        
    #if __MACOSX__
        backgroundMusic.Load("SDLAudio.app/Contents/Resources/Music.mp3");
    #else
        backgroundMusic.Load("Music.mp3");
    #endif
    
    backgroundMusic.PlayRepeatedly();
    
    /*
	soundEffect = new GameSound;
    if (soundEffect == NULL)
        done = true;
	*/
	
    Mix_AllocateChannels(8);
    
    // Look in the application bundle for the sound file on Mac OS X.
    // Look in the directory where the executable file resides on other operating systems.        
    #if __MACOSX__
        soundEffect.Load("SDLAudio.app/Contents/Resources/SoundEffect.ogg");
    #else
        soundEffect.Load("SoundEffect.ogg");
    #endif
        
}

void GameApp::InitializeSDL(void)
{
    int error;
    SDL_Surface* drawContext;
    
    error = SDL_Init(SDL_INIT_EVERYTHING);
    
    // Create a double-buffered draw context
    SDL_GL_SetAttribute(SDL_GL_DOUBLEBUFFER, 1);
    
    Uint32 flags;
    flags = SDL_OPENGL;// | SDL_FULLSCREEN;
    drawContext = SDL_SetVideoMode(640, 480, 0, flags);
        
}

void GameApp::InitializeDrawContext(Uint16 width, Uint16 height)
{
    // Create the draw context
	/*
	context = new GameContext;
	if (context == NULL)
		// Quit
        done = true;
   */
   
    // Create the background texture map
    GameTexture textureMap; //= new GameTexture;

    textureMap.SetInternalFormat(GL_RGBA8);
    
    textureMap.SetFormat(GL_RGBA);
    
    // The texture was created on a big endian computer so reverse
    // the byte order on a little endian computer.
    #if __BIG_ENDIAN__
        textureMap.SetType(GL_UNSIGNED_INT_8_8_8_8);
    #else
        textureMap.SetType(GL_UNSIGNED_INT_8_8_8_8_REV);
    #endif

    // Look in the application bundle for the background texture file on Mac OS X.
    // Look in the directory where the executable file resides on other operating systems.
    #if __MACOSX__
        textureMap.Load("SDLAudio.app/Contents/Resources/Background.png");
    #else
        textureMap.Load("Background.png");
    #endif
        
    context.SetBackground(textureMap);
    
    // Create the sprite storage texture map.
    GameTexture playerTextureMap; // = new GameTexture;

    playerTextureMap.SetInternalFormat(GL_RGBA8);
    
    playerTextureMap.SetFormat(GL_RGBA);
    
    // The texture was created on a big endian computer so reverse
    // the byte order on a little endian computer.
    #if __BIG_ENDIAN__
        playerTextureMap.SetType(GL_UNSIGNED_INT_8_8_8_8);
    #else
        playerTextureMap.SetType(GL_UNSIGNED_INT_8_8_8_8_REV);
    #endif

    // Look in the application bundle for the player ship texture file on Mac OS X.
    // Look in the directory where the executable file resides on other operating systems.        
    #if __MACOSX__
        playerTextureMap.Load("SDLAudio.app/Contents/Resources/PlayerShip.png");
    #else
        playerTextureMap.Load("PlayerShip.png");
    #endif
        
    context.SetPlayerSpriteStorage(playerTextureMap);
    
    // Set the size of the context.
    context.SetWidth(width);
    context.SetHeight(height);
    gluOrtho2D(0.0, width, 0.0, height);
    
}

void GameApp::InstallTimer(void)
{
    timer = SDL_AddTimer(30, GameLoopTimer, this);
}

Uint32 GameApp::GameLoopTimer(Uint32 interval, void* param)
{
    //GameAppPtr currentApp = (GameAppPtr)param;
    
    //currentApp->GameLoop();
    
    // Create a user event to call the game loop.
    SDL_Event event;
    
    event.type = SDL_USEREVENT;
    event.user.code = RUN_GAME_LOOP;
    event.user.data1 = 0;
    event.user.data2 = 0;
    
    SDL_PushEvent(&event);
    
    return interval;
}


// Cleanup functions
void GameApp::Cleanup(void)
{
    InputControllerPtr controller = player1.GetPlayerController();
    SDL_JoystickClose(controller->GetJoystick());
    
    //delete player1;
    //delete context;
    
    SDL_bool success;
    success = SDL_RemoveTimer(timer);
    
    SDL_Quit();
}

// Event-related functions
void GameApp::EventLoop(void)
{
    SDL_Event event;
    InputControllerPtr controller = player1.GetPlayerController();
    
    while((!done) && (SDL_WaitEvent(&event))) {
        switch(event.type) {
            case SDL_USEREVENT:
                HandleUserEvents(&event);
                break;
                
            case SDL_KEYDOWN:
                controller->HandleKeyPress(&event);
                break;

            case SDL_KEYUP:
                controller->HandleKeyUp(&event);
                break;
                
            case SDL_MOUSEBUTTONDOWN:
                soundEffect.Play(1);
                break;

            case SDL_MOUSEBUTTONUP:
                controller->HandleMouseButtonUp(&event);
                break;
                
            case SDL_MOUSEMOTION:
                controller->HandleMouseMovement(&event);
                break;
                
            case SDL_JOYBUTTONDOWN:
                soundEffect.Play(1);
                break;

            case SDL_JOYBUTTONUP:
                controller->HandleJoystickButtonUp(&event);
                break;
                
            case SDL_JOYAXISMOTION:
                controller->HandleJoystickAxisMovement(&event);
                break;
                
            case SDL_QUIT:
                done = true;
                break;
                
            default:
                break;
        }   // End switch
        
    }   // End while
    
}

void GameApp::HandleUserEvents(SDL_Event* event)
{
    switch (event->user.code) {
        case RUN_GAME_LOOP:
            GameLoop();
            break;
            
        default:
            break;
    }
}


// Game related functions
void GameApp::GameLoop(void)
{
    player1.Move();
    RenderFrame();
}

void GameApp::RenderFrame(void) 
{
    glClear(GL_COLOR_BUFFER_BIT);
    context.DrawBackground();
    context.DrawPlayer(&player1);
    SDL_GL_SwapBuffers();
}
