/*
 *  GameContext.h
 *  SDLGame
 *
 *  Created by Mark Szymczyk on 6/21/06.
 *  Copyright 2006 Me and Mark Publishing. All rights reserved.
 *
 */

#include "SDL.h"
#include "SDL_OpenGL.h"

#ifndef GAME_TEXTURE
    #include "GameTexture.h"
#endif

#ifndef GAME_SPRITE
    #include "GameSprite.h"
#endif

#define GAME_CONTEXT

class GameContext 
{
    protected:
        GameTexture background;
        GameTexture playerSpriteStorage;

        Uint16 width;
        Uint16 height;
        
    public:
        // Constructor and destructor
        GameContext(void);
        virtual ~GameContext(void);
    
        // Accessors
        GameTexture GetBackground(void);
        void SetBackground(GameTexture theBackground);

        GameTexture GetPlayerSpriteStorage(void);
        void SetPlayerSpriteStorage(GameTexture theStorage);

        Uint16 GetWidth(void);
        void SetWidth(Uint16 theWidth);
        
        Uint16 GetHeight(void);
        void SetHeight(Uint16 theHeight);
        
        // Drawing functions
        void DrawBackground(void);
        void DrawPlayer(GameSprite player);
};

typedef GameContext* GameContextPtr;
typedef GameContext** GameContextHandle;
