/*
 *  GameApp.h
 *  SDLGame
 *
 *  Created by Mark Szymczyk on 6/12/06.
 *  Copyright 2006 Me and Mark Publishing. All rights reserved.
 *
 */

#include "SDL.h"
#include "SDL_OpenGL.h"
#include "SDL_image.h"

#ifndef GAME_CONTEXT
    #include "GameContext.h"
#endif

#ifndef GAME_SPRITE
    #include "GameSprite.h"
#endif

class GameApp
{
    protected:
        SDL_TimerID timer;
        bool done;
        GameContext context;
        GameSprite player1;
    
    public:
        // Constructor and destructor
        GameApp (void);
        virtual ~GameApp(void);

        // Accessors
        GameContext GetContext(void);
        void SetContext(GameContext theContext);

        GameSprite GetPlayer1(void);
        void SetPlayer1(GameSprite thePlayer);

        // Initialization functions
        void InitApp(void);
        void InitializeSDL(void);
        void InitializeDrawContext(Uint16 width, Uint16 height);
        void InstallTimer(void);
        static Uint32 GameLoopTimer(Uint32 interval, void* param);
    
        // Cleanup functions
        void Cleanup(void);
    
        // Event-related functions
        void EventLoop(void);
        void HandleUserEvents(SDL_Event* event);
        void HandleKeyPress(SDL_Event* event);
        void HandleMouseMovement(SDL_Event* event);
    
        // Game related functions
        void GameLoop(void);
        void RenderFrame(void);
    
};

typedef GameApp* GameAppPtr;
typedef GameApp** GameAppHandle;

const int RUN_GAME_LOOP = 1;
const float MOVEMENT_DISTANCE = 10.0f;
const float ROTATION_AMOUNT = 5.0f;