/*
 *  GameApp.cpp
 *  SDLGame
 *
 *  Created by Mark Szymczyk on 6/12/06.
 *  Copyright 2006 Me and Mark Publishing. All rights reserved.
 *
 */

#include "GameApp.h"

// Constructor
GameApp::GameApp(void)
{
    done = false;
}

// Destructor
GameApp::~GameApp(void)
{

}


// Accessors
GameContext GameApp::GetContext(void)
{
    return context;
}

void GameApp::SetContext(GameContext theContext)
{
    context = theContext;
}

GameSprite GameApp::GetPlayer1(void)
{
    return player1;
}

void GameApp::SetPlayer1(GameSprite thePlayer)
{
    player1 = thePlayer;
}


// Initialization functions
void GameApp::InitApp(void)
{
    InitializeSDL();
    InitializeDrawContext(640, 480);
    InstallTimer();
    
    //player1 = new GameSprite;
    player1.SetWorldX(320.0);
    player1.SetWorldY(240.0);
    player1.SetOrientation(0.0);
    
}

void GameApp::InitializeSDL(void)
{
    int error;
    SDL_Surface* drawContext;
    
    error = SDL_Init(SDL_INIT_EVERYTHING);
    
    // Create a double-buffered draw context
    SDL_GL_SetAttribute(SDL_GL_DOUBLEBUFFER, 1);

    // Use 32-bit color: 8 bits of red, green, blue, and alpha.
    SDL_GL_SetAttribute(SDL_GL_RED_SIZE, 8);
    SDL_GL_SetAttribute(SDL_GL_GREEN_SIZE, 8);
    SDL_GL_SetAttribute(SDL_GL_BLUE_SIZE, 8);
    SDL_GL_SetAttribute(SDL_GL_ALPHA_SIZE, 8);
    
    Uint32 flags;
    flags = SDL_OPENGL;// | SDL_FULLSCREEN;
    drawContext = SDL_SetVideoMode(640, 480, 0, flags);
        
}

void GameApp::InitializeDrawContext(Uint16 width, Uint16 height)
{
    // Create the draw context
	/*
    context = new GameContext;
	if (context == NULL)
		// Quit
        done = true;
   */
    
    // Create the background texture map
    GameTexture textureMap;// = new GameTexture;

    textureMap.SetInternalFormat(GL_RGBA8);
    
    textureMap.SetFormat(GL_RGBA);
    
    // The texture was created on a big endian computer so reverse
    // the byte order on a little endian computer.
    #if __BIG_ENDIAN__
        textureMap.SetType(GL_UNSIGNED_INT_8_8_8_8);
    #else
        textureMap.SetType(GL_UNSIGNED_INT_8_8_8_8_REV);
    #endif
        
    // Look in the application bundle for the background texture file on Mac OS X.
    // Look in the directory where the executable file resides on other operating systems.
    #if __MACOSX__
        textureMap.Load("SDLAnimation.app/Contents/Resources/Background.png");
    #else
        textureMap.Load("Background.png");
    #endif
        
    context.SetBackground(textureMap);
    
    // Create the sprite storage texture map.
    GameTexture playerTextureMap;// = new GameTexture;

    playerTextureMap.SetInternalFormat(GL_RGBA8);
    
    playerTextureMap.SetFormat(GL_RGBA);
    
    // The texture was created on a big endian computer so reverse
    // the byte order on a little endian computer.
    #if __BIG_ENDIAN__
        playerTextureMap.SetType(GL_UNSIGNED_INT_8_8_8_8);
    #else
        playerTextureMap.SetType(GL_UNSIGNED_INT_8_8_8_8_REV);
    #endif

    // Look in the application bundle for the player ship texture file on Mac OS X.
    // Look in the directory where the executable file resides on other operating systems.        
    #if __MACOSX__
        playerTextureMap.Load("SDLAnimation.app/Contents/Resources/PlayerShip.png");
    #else
        playerTextureMap.Load("PlayerShip.png");
    #endif
        
    context.SetPlayerSpriteStorage(playerTextureMap);
    
    // Set the size of the context.
    context.SetWidth(width);
    context.SetHeight(height);
    gluOrtho2D(0.0, width, 0.0, height);
    
}

void GameApp::InstallTimer(void)
{
    timer = SDL_AddTimer(30, GameLoopTimer, this);
}

Uint32 GameApp::GameLoopTimer(Uint32 interval, void* param)
{
    //GameAppPtr currentApp = (GameAppPtr)param;
    
    //currentApp->GameLoop();
    
    // Create a user event to call the game loop.
    SDL_Event event;
    
    event.type = SDL_USEREVENT;
    event.user.code = RUN_GAME_LOOP;
    event.user.data1 = 0;
    event.user.data2 = 0;
    
    SDL_PushEvent(&event);
    
    return interval;
}


// Cleanup functions
void GameApp::Cleanup(void)
{
    SDL_bool success;
    success = SDL_RemoveTimer(timer);
    
    SDL_Quit();
}

// Event-related functions
void GameApp::EventLoop(void)
{
    SDL_Event event;
    
    while((!done) && (SDL_WaitEvent(&event))) {
        switch(event.type) {
            case SDL_USEREVENT:
                HandleUserEvents(&event);
                break;
                
            case SDL_KEYDOWN:
                HandleKeyPress(&event);
                break;
                
            case SDL_MOUSEMOTION:
                HandleMouseMovement(&event);
                break;
                
            case SDL_QUIT:
                done = true;
                break;
                
            default:
                break;
        }   // End switch
        
    }   // End while
    
}

void GameApp::HandleUserEvents(SDL_Event* event)
{
    switch (event->user.code) {
        case RUN_GAME_LOOP:
            GameLoop();
            break;
            
        default:
            break;
    }
}

void GameApp::HandleKeyPress(SDL_Event* event)
{
    switch(event->key.keysym.sym) {
        case SDLK_LEFT:
            player1.MoveLeft(MOVEMENT_DISTANCE);
            player1.SetOrientation(90.0f);
            break;

        case SDLK_RIGHT:
            player1.MoveRight(MOVEMENT_DISTANCE);
            player1.SetOrientation(270.0f);
            break;

        case SDLK_UP:
            player1.MoveUp(MOVEMENT_DISTANCE);
            player1.SetOrientation(0.0f);
            break;

        case SDLK_DOWN:
            player1.MoveDown(MOVEMENT_DISTANCE);
            player1.SetOrientation(180.0f);
            break;
            
        default:
            break;
    }
}

void GameApp::HandleMouseMovement(SDL_Event* event)
{
    float newOrientation;
    
    Sint16 xMovement;
    xMovement = event->motion.xrel;
    
    // Move left
    if (xMovement < 0) {
        newOrientation = player1.GetOrientation() + ROTATION_AMOUNT;
        if (newOrientation >= 360.0)
            newOrientation = 0.0f;
        player1.SetOrientation(newOrientation);
    }
    
    // Move right
    if (xMovement > 0) {
        newOrientation = player1.GetOrientation() - ROTATION_AMOUNT;
        if (newOrientation <= 0.0)
            newOrientation = 360.0f;
        player1.SetOrientation(newOrientation);
    }
}


// Game related functions
void GameApp::GameLoop(void)
{
    RenderFrame();
}

void GameApp::RenderFrame(void) 
{
    glClear(GL_COLOR_BUFFER_BIT);
    context.DrawBackground();
    context.DrawPlayer(player1);
    SDL_GL_SwapBuffers();
}
