// Vector2D.h	by Mark Szymczyk
// Book version

// Include math.h for the square root function
#include <math.h>

#define VECTOR_2D

// Must put the typedefs here so the Vector2D class
// knows what Vector2DPtr and Vector2DHandle are.
class Vector2D;
typedef Vector2D* Vector2DPtr;
typedef Vector2D** Vector2DHandle;

class Vector2D
{
	protected:
		double x;
		double y;
		
	public:
		Vector2D(void);
		Vector2D(const Vector2D& theVector); // Copy constructor
		virtual ~Vector2D(void);

		// Overload assignment operator
		Vector2D& operator= (const Vector2D& theVector);
		
		// Accessors
		double GetXComponent(void);
		void SetXComponent(double xValue);

		double GetYComponent(void);
		void SetYComponent(double yValue);
		
		double GetLength(void);
		static Vector2D VectorSum(Vector2DPtr u, Vector2DPtr v);
		static Vector2D VectorDifference(Vector2DPtr u, Vector2DPtr v);
		static Vector2D ScalarProduct(Vector2DPtr v, double scalar);
		static double DotProduct(Vector2DPtr u, Vector2DPtr v);
		static Vector2D GetPerpendicularVector(Vector2DPtr v);
};

