// Vector2D.cp		by Mark Szymczyk
// Book version

#ifndef VECTOR_2D
	#include "Vector2D.h"
#endif

// Constructor
Vector2D::Vector2D(void)
{
	SetXComponent(0.0);
	SetYComponent(0.0);
}

Vector2D::Vector2D(const Vector2D& theVector)
{
	x = theVector.x;
	y = theVector.y;
}

// Destructor
Vector2D::~Vector2D(void)
{
	
}
// Overload assignment operator
// This fixes a problem when trying to set a GameSprite
// object's position, velocity, and acceleration in the
// PhysicsController class.
Vector2D& Vector2D::operator= (const Vector2D& theVector)
{

	if (this != &theVector) {	// Avoid self-assignment
		x = theVector.x;
		y = theVector.y;
	}
	
	return *this;
}


// Accessors
double Vector2D::GetXComponent(void)
{
	return x;
}

void Vector2D::SetXComponent(double xValue)
{
	x = xValue;
}

double Vector2D::GetYComponent(void)
{
	return y;
}

void Vector2D::SetYComponent(double yValue)
{
	y = yValue;
}


// Other functions
double Vector2D::Vector2D::GetLength(void)
{
	double result;
	double xSquared = x * x;
	double ySquared = y * y;
	
	result = sqrt(xSquared + ySquared);
	return result;
}

Vector2D Vector2D::VectorSum(Vector2DPtr u, Vector2DPtr v)
{
	Vector2D result;
	result.x = u->GetXComponent() + v->GetXComponent();
	result.y = u->GetYComponent() + v->GetYComponent();
	
	return result;
}

Vector2D Vector2D::VectorDifference(Vector2DPtr u, Vector2DPtr v)
{
	Vector2D result;
	result.x = u->GetXComponent() - v->GetXComponent();
	result.y = u->GetYComponent() - v->GetYComponent();
	
	return result;
}

Vector2D Vector2D::ScalarProduct(Vector2DPtr v, double scalar)
{
	// This function multiplies a vector by a scalar quantity
	// Many books refer to the dot product of two vectors as a
	// scalar product, but I cant think of a better function name
	// for multiplying a vector by a scalar than ScalarProduct.
	Vector2D result;
	result.x = v->GetXComponent() * scalar;
	result.y = v->GetYComponent() * scalar;
	
	return result;
}

double Vector2D::DotProduct(Vector2DPtr u, Vector2DPtr v)
{
	double x1 = u->GetXComponent();
	double y1 = u->GetYComponent();
	double x2 = v->GetXComponent();
	double y2 = v->GetYComponent();

	double result = (x1 * x2) + (y1 * y2);
	return result;
}

// This is the alternative DotProduct() function
// which I've commented out.
/*
double Vector2D::DotProduct(Vector2DPtr u, Vector2DPtr v, double theta)
{
	double uLength = u->GetLength();
	double vLength = v->GetLength();

	double result = uLength * vLength * cos(theta);
	return result;
}
*/

Vector2D Vector2D::GetPerpendicularVector(Vector2DPtr v)
{
	// The perpendicular vector of v = <x, y> can be either
	// <-y, x> or <y, -x>
	// I chose to use <-y, x> for this function
	Vector2D result;
	result.x = v->GetYComponent() * -1.0;
	result.y = v->GetXComponent();
	
	return result;
}

