// StateTransition.h		by Mark Szymczyk

#ifndef __CARBON__
    #include <Carbon/Carbon.h>
#endif

// Need to include FiniteState.h for the StateType data type
/*
#ifndef FINITE_STATE
    #include "FiniteState.h"
#endif
*/

#define STATE_TRANSITION

// The states an enemy can be in during the game
enum StateType
{
    kStandingState = 0, 
	kPatrollingState, 
	kChasingState,
	kFleeingState,
	kStatesInGame
};

// The state transitions in our game
enum StateTransitionType
{
	kEmptyTransition = -1,
    kPlayerEntersView = 0, 
	kPlayerAttacks, 
	kPlayerEscapes,
	kSeverelyWounded,
	kEvadedPlayer,
	kReceivedHelp,
	kTransitionsInGame
};	

class StateTransition
{
	protected:
        StateTransitionType transitionTrigger;
        StateType newState;
        
        // If you want to include probability, remove the comments
        //short transitionChances;		// Between 0 and 100
    public:
        // Constructor and destructor
        StateTransition(void);
        StateTransition(const StateTransition& theTransition);	// Copy constructor
        virtual ~StateTransition(void);

		// Overload assignment operator
		StateTransition& operator= (const StateTransition& theTransition);
        
        // Accessors
        StateTransitionType GetTransitionTrigger(void);
        void SetTransitionTrigger(StateTransitionType theTrigger);
        
        StateType GetNewState(void);
        void SetNewState(StateType theState);
        
        
};

typedef StateTransition* StateTransitionPtr;
typedef StateTransition** StateTransitionHandle;
