// StateTransition.cp	by Mark Szymczyk

#ifndef STATE_TRANSITION
    #include "StateTransition.h"
#endif

// Constructor
StateTransition::StateTransition(void)
{

}

// Copy constructor
StateTransition::StateTransition(const StateTransition& theTransition)
{
    transitionTrigger = theTransition.transitionTrigger;
    newState = theTransition.newState;
}

// Destructor
StateTransition::~StateTransition(void)
{

}

// Overload assignment operator
StateTransition& StateTransition::operator= (const StateTransition& theTransition)
{
    if (this != &theTransition) {		// Avoid self assignment
        transitionTrigger = theTransition.transitionTrigger;
        newState = theTransition.newState;
    }
    
    return *this;        
}

// Accessors
StateTransitionType StateTransition::GetTransitionTrigger(void)
{
    return transitionTrigger;
}

void StateTransition::SetTransitionTrigger(StateTransitionType theTrigger)
{
    transitionTrigger = theTrigger;
}
        
StateType StateTransition::GetNewState(void)
{
    return newState;
}

void StateTransition::SetNewState(StateType theState)
{
    newState = theState;
}

