// PhysicsController.h	by Mark Szymczyk
// Book version

#ifndef __CARBON__
    #include <Carbon/Carbon.h>
#endif

#ifndef VECTOR_2D
	#include "Vector2D.h"
#endif

#ifndef GAME_SPRITE
	#include "GameSprite.h"
#endif

// We need the InputController class to
// get the movements to handle.
#ifndef INPUT_CONTROLLER
	#include "InputController.h"
#endif

#ifndef GAME_COLLISION
	#include "GameCollision.h"
#endif

#define PHYSICS_CONTROLLER

// Must put the typedefs here so the PhysicsController class
// knows what PhysicsControllerPtr and PhysicsControllerHandle are.
//class PhysicsController;
//typedef PhysicsController* PhysicsControllerPtr;
//typedef PhysicsController** PhysicsControllerHandle;

class PhysicsController
{
	protected:
		GameSpritePtr modelToControl;
			
	public:
		PhysicsController();
		virtual ~PhysicsController(void);
		
		// Accessor functions
		GameSpritePtr GetModelToControl(void); 			
		void SetModelToControl(GameSpritePtr theModel); 	


		void UpdatePhysics(InputControllerAction theAction, Vector2DPtr force, double timeStep,
				GameLevelPtr currentLevel, GameTileListPtr theTileList);

		// Linear motion functions
		Vector2D CalculateCenterOfMass(void);
		void CalculateAcceleration(Vector2DPtr force);
		void CalculateVelocity(double timeStep);
		void Move(double timeStep);
		
		// Angular motion functions
		double CalculateMomentOfInertia(GameSpritePtr model);
		void CalculateAngularAcceleration(double torque);
		void CalculateLinearAcceleration(Vector2DPtr originVector);
		void CalculateAngularVelocity(double timeStep);
		void CalculateLinearVelocity(Vector2DPtr originVector);
		void Rotate(double timeStep);
		
		virtual void Stand(void);

		// Movement determination functions
		virtual Boolean CanMoveUp(short distance, GameLevelPtr currentLevel, GameTileListPtr theTileList);
		virtual Boolean CanMoveDown(short distance, GameLevelPtr currentLevel, GameTileListPtr theTileList);
		virtual Boolean CanMoveLeft(short distance, GameLevelPtr currentLevel, GameTileListPtr theTileList);
		virtual Boolean CanMoveRight(short distance, GameLevelPtr currentLevel, GameTileListPtr theTileList);
		virtual Boolean CanMoveUpAndLeft(short distance, GameLevelPtr currentLevel, GameTileListPtr theTileList);
		virtual Boolean CanMoveUpAndRight(short distance, GameLevelPtr currentLevel, GameTileListPtr theTileList);
		virtual Boolean CanMoveDownAndLeft(short distance, GameLevelPtr currentLevel, GameTileListPtr theTileList);
		virtual Boolean CanMoveDownAndRight(short distance, GameLevelPtr currentLevel, GameTileListPtr theTileList);
		
		short HowFarUp(void);
		short HowFarDown(void);
		short HowFarLeft(void);
		short HowFarRight(void);
	
		// Collision related functions
		Boolean DetectCollision(GameSpritePtr collidingModel);
		Boolean DetectExactCollision(GameSpritePtr collidingModel);
		
		void ResolveCollision(GameCollisionPtr theCollision);
		double CalculateLinearImpulse(GameCollisionPtr theCollision);
		double CalculateAngularImpulse(GameCollisionPtr theCollision);
		void CalculatePostCollisionLinearVelocities(GameCollisionPtr theCollision, double impulse);
		void CalculatePostCollisionAngularVelocities(GameCollisionPtr theCollision, double impulse);

};

typedef PhysicsController* PhysicsControllerPtr;
typedef PhysicsController** PhysicsControllerHandle;

// Constants

		