// MovableModalDialog.h		by Mark Szymczyk
// Book version

//	A base class for movable modal dialog boxes.

#ifndef __CARBON__
    #include <Carbon/Carbon.h>
#endif

#define MOVABLE_MODAL_DIALOG

class MovableModalDialog 
{
	protected:
        DialogRef dialog;
        
    public:
		// Constructor and destructor
		MovableModalDialog(void);
        virtual ~MovableModalDialog(void);
        
        // Accessors
        DialogRef GetDialog(void);
        void SetDialog(DialogRef theDialog);
        
		
		void Create(short resourceID);
        void Show(void);
		
        // Event related functions
        virtual void Drag(EventRecord* event);
        virtual void Grow(EventRecord* event);
        virtual void Zoom(int zoomInOrOut);
        virtual void Update(void);
		virtual void Close(void);
		void DoContent(EventRecord* event);
		void HandleKeyDown(EventRecord* event);
		virtual void DoDialogEvent(EventRecord* event);
		virtual void DoItemHit(short theItem);
		
		//void Activate(void);
		//void Deactivate(void);
		
};

typedef MovableModalDialog* MovableModalDialogPtr;
typedef MovableModalDialog** MovableModalDialogHandle;

// constants
const short kDialogID = 200;
	
	