// MovableModalDialog.cp	by Mark Szymczyk

#ifndef MOVABLE_MODAL_DIALOG
	#include "MovableModalDialog.h"
#endif

// Constructor
MovableModalDialog::MovableModalDialog(void)
{
	dialog = nil;
}

// Destructor
MovableModalDialog::~MovableModalDialog(void)
{
	Close();
}

// Accessors
DialogRef MovableModalDialog::GetDialog(void)
{
    return dialog;
}
        
void MovableModalDialog::SetDialog(DialogRef theDialog)
{
    dialog = theDialog;
}


// Creating and displaying dialog boxes
void MovableModalDialog::Create(short resourceID)
{
	//WindowPtr(-1) will bring the dialog box to the front
	dialog = GetNewDialog(resourceID, nil, WindowPtr(-1));
}

void MovableModalDialog::Show(void)
{
	if (dialog != nil) {
		ShowWindow(GetDialogWindow(dialog));
		SetPort(GetDialogPort(dialog));
	}
}


// Event related functions
void MovableModalDialog::Drag(EventRecord* event)
{
    // This function lets the player move the dialog box.
    
	RgnHandle	grayRgn;
	Rect 		boundRect;
	
	grayRgn = GetGrayRgn();
	GetRegionBounds(grayRgn, &boundRect);
	DragWindow(GetDialogWindow(dialog), event->where, &boundRect);	
}

void MovableModalDialog::Grow(EventRecord* event)
{
    // If you derive dialog box classes where
    // the box can grow, you would fill in this function.
}

void MovableModalDialog::Zoom(int zoomInOrOut)
{
    // If you derive dialog box classes where
    // the box can zoom, you would fill in this function.

}

void MovableModalDialog::Update(void)
{
    // We just redraw the dialog box contents when
    // the dialog box gets an update event.
    DrawDialog(dialog);
}

void MovableModalDialog::Close(void)
{
	if (dialog != nil) {
		DisposeDialog(dialog);
		dialog = nil;
	}
	
	//return true;
}
	
void MovableModalDialog::DoContent(EventRecord* event)
{
    DoDialogEvent(event);
}

void MovableModalDialog::HandleKeyDown(EventRecord* event)
{
	DoDialogEvent(event);
}

void MovableModalDialog::DoDialogEvent(EventRecord* event)
{
	short itemHit;
	
    // The Dialog Manager DialogSelect() does most
    // of the work for us when handling dialog events.
    
	if (IsDialogEvent(event)) {
		if (DialogSelect(event, &dialog, &itemHit))
			DoItemHit(itemHit);
	}
	
}

void MovableModalDialog::DoItemHit(short theItem)
{
    // Do nothing because we don't know what items
    // are in this particular dialog box.  We will
    // derive classes that will handle this function.
}
