// LinkedList.h
//	class declarations for the linked list class

#ifndef __CARBON__
    #include <Carbon/Carbon.h>
#endif

#define LINKED_LIST

class Link
{
	protected:
		Link*	nextLink;
		void*	item;
		
	public:
		Link(Link* n = nil, void* theItem = nil);
		Link* GetNextLink(void);
		void* GetTheItem(void);
		void SetNextLink(Link* link);
		void SetTheItem(void* theItem);
};

class LinkedList
{
	protected:
		friend class Iterator;
		Link*	firstLink;
		int		numberOfItems;
		
	public:
		LinkedList(void);
		virtual void AddItem(void* itemToAdd);
		virtual void RemoveItem(void* itemToRemove);
		int	GetNumberOfItems(void);
};

class Iterator 
{
	protected:
		Link*	currentLink;

	public:
		Iterator(LinkedList* list);
		void* Next(void);
};
