// LinkedList.cp
//	definitions of the LinkedList functions

#ifndef LINKED_LIST
    #include "LinkedList.h"
#endif

Link::Link(Link* n, void* theItem)
{
	nextLink = n;
	item = theItem;
}

Link* Link::GetNextLink(void)
{
	return nextLink;
}

void* Link::GetTheItem(void)
{
	return item;
}

void Link::SetNextLink(Link* link)
{
	nextLink = link;
}

void Link::SetTheItem(void* theItem)
{
	item = theItem;
}


LinkedList::LinkedList(void)
{
	firstLink = nil;
	numberOfItems = 0;
}

void LinkedList::AddItem(void* itemToAdd)
{
	firstLink = new Link(firstLink, itemToAdd);
	numberOfItems++;
}

void LinkedList::RemoveItem(void* itemToRemove)
{
	Link*	temp;
	Link*	previousLink;
	
	previousLink = nil;
	
	for(temp = firstLink; temp != nil; temp = temp->GetNextLink()) {
		if(temp->GetTheItem() == itemToRemove) {
			// if we're removing the first item in the list, just reset the first item
			if(previousLink == nil)
				firstLink = temp->GetNextLink();
			else
				previousLink->SetNextLink(temp->GetNextLink());
				
			delete temp;
			numberOfItems--;
			return;
		}
		else
			previousLink = temp;
	}
}

int LinkedList::GetNumberOfItems(void)
{
	return numberOfItems;
}


Iterator::Iterator(LinkedList* list)
{
	currentLink = list->firstLink;
}

void* Iterator::Next(void)
{
	Link*	theLink = currentLink;
	
	if (currentLink != nil) {
		currentLink = currentLink->GetNextLink();
		return (theLink->GetTheItem());
	}
	else {
		return nil;
	}
}

