// InputDeviceElement.h		by Mark Szymczyk

#ifndef __COREFOUNDATION__
    #include <CoreFoundation/CoreFoundation.h>
#endif

#ifndef __CARBON__
    #include <Carbon/Carbon.h>
#endif

#ifndef _IOKIT_HID_IOHIDLIB_H_
    #include <IOKit/hid/IOHIDLib.h>
#endif

#ifndef _IOKIT_HID_IOHIDKEYS_H_
    #include <IOKit/hid/IOHIDKeys.h>
#endif

#define INPUT_DEVICE_ELEMENT

// The InputDeviceElement contains all the data fields
// for a HID Manager input device element.  You may not
// need to be concerned with every field, but they are all
// here if you need them.

class InputDeviceElement
{
    public:
        // Have to make string data members public
        // because C language functions cannot return arrays.
        Str255 elementName;

    protected:
        IOHIDElementCookie cookie;			// Unique identifier for the element
        IOHIDElementType type;		
        long usage;							// Specific control use of the element
        long usagePage;						// General control use of the element
        
        long rawMin;						// raw minimum value for the element
        long rawMax;
        long scaledMin;						// scaled minimum value
        long scaledMax;
        
        long size;							// The size of the data (in bits) the element returns
        
        Boolean isRelative;
        Boolean isWrapping;
        Boolean isNonLinear;
        Boolean hasPreferredState;
        Boolean hasNullState;
        
        long units;
        long unitExponent;
                
    public:
        // Constructor and destructor
        InputDeviceElement(void);
        virtual ~InputDeviceElement(void);
        
        // Accessors
        IOHIDElementCookie GetCookie(void);
        void SetCookie(IOHIDElementCookie theCookie);
        
        IOHIDElementType GetType(void);
        void SetType(IOHIDElementType theType);
        
        long GetUsage(void);
        void SetUsage(long theUsage);
        
        long GetUsagePage(void);
        void SetUsagePage(long theUsagePage);
        
        long GetRawMin(void);
        void SetRawMin(long min);

        long GetRawMax(void);
        void SetRawMax(long max);

        long GetScaledMin(void);
        void SetScaledMin(long min);

        long GetScaledMax(void);
        void SetScaledMax(long max);

        long GetSize(void);
        void SetSize(long theSize);
        
        Boolean IsRelative(void);
        void SetRelative(Boolean relativeValue);
        
        Boolean IsWrapping(void);
        void SetWrapping(Boolean wrappingValue);

        Boolean IsNonLinear(void);
        void SetNonLinear(Boolean nonLinearValue);

        Boolean HasPreferredState(void);
        void SetPreferredState(Boolean preferredStateValue);

        Boolean HasNullState(void);
        void SetNullState(Boolean nullStateValue);

        long GetUnits(void);
        void SetUnits(long unitValue);
        
        long GetUnitExponent(void);
        void SetUnitExponent(long exponentValue);        
        
        // Other functions
        void StoreElementData(CFTypeRef theElement);
        
        void StoreCookieData(CFTypeRef theElement);
        void StoreTypeData(CFTypeRef theElement);
        void StoreUsagePageData(CFTypeRef theElement);
        void StoreUsageData(CFTypeRef theElement);
        void StoreRawMinData(CFTypeRef theElement);
        void StoreRawMaxData(CFTypeRef theElement);
        void StoreScaledMinData(CFTypeRef theElement);
        void StoreScaledMaxData(CFTypeRef theElement);
        void StoreSizeData(CFTypeRef theElement);
        void StoreIsRelativeData(CFTypeRef theElement);
        void StoreIsWrappingData(CFTypeRef theElement);
        void StoreIsNonLinearData(CFTypeRef theElement);
        void StoreHasPreferredStateData(CFTypeRef theElement);
        void StoreHasNullStateData(CFTypeRef theElement);
        void StoreUnitsData(CFTypeRef theElement);
        void StoreUnitExponentData(CFTypeRef theElement);
        void StoreElementNameData(CFTypeRef theElement);
        void StoreElementNameFromResource(void);

};

typedef InputDeviceElement* InputDeviceElementPtr;
typedef InputDeviceElement** InputDeviceElementHandle;
        
// Constants
const short kGenericDesktopStringListID = 128;
const short kButtonStringListID = 129;

// Usage page constants
const long kGenericDesktopPage = 0x01;
const long kButtonPage = 0x09;

// Usage constants
const long kJoystickUsage = 0x04;
const long kGamepadUsage = 0x05;
const long kXAxisUsage = 0x30;
const long kYAxisUsage = 0x31;
const long kButton1Usage = 0x01;
const long kButton2Usage = 0x02;
const long kButton3Usage = 0x03;
// Place any additional buttons here
        