// InputDeviceElement.cpp	by Mark Szymczyk

#ifndef INPUT_DEVICE_ELEMENT
    #include "InputDeviceElement.h"
#endif

// Constructor 
InputDeviceElement::InputDeviceElement(void)
{

}

// Destructor
InputDeviceElement::~InputDeviceElement(void) 
{

}

        
// Accessors
IOHIDElementCookie InputDeviceElement::GetCookie(void)
{
    return cookie;
}

void InputDeviceElement::SetCookie(IOHIDElementCookie theCookie)
{
    cookie = theCookie;
}
        
IOHIDElementType InputDeviceElement::GetType(void)
{
    return type;
}
 
void InputDeviceElement::SetType(IOHIDElementType theType)
{
    type = theType;
}

long InputDeviceElement::GetUsage(void)
{
    return usage;
}

void InputDeviceElement::SetUsage(long theUsage)
{
    usage = theUsage;
}
        
long InputDeviceElement::GetUsagePage(void)
{
    return usagePage;
}
        
void InputDeviceElement::SetUsagePage(long theUsagePage)
{
    usagePage = theUsagePage;
}
        
long InputDeviceElement::GetRawMin(void)
{
    return rawMin;
}

void InputDeviceElement::SetRawMin(long min)
{
    rawMin = min;
}

long InputDeviceElement::GetRawMax(void)
{
    return rawMax;
}

void InputDeviceElement::SetRawMax(long max)
{
    rawMax = max;
}

long InputDeviceElement::GetScaledMin(void)
{
    return scaledMin;
}

void InputDeviceElement::SetScaledMin(long min)
{
    scaledMin = min;
}

long InputDeviceElement::GetScaledMax(void)
{
    return scaledMax;
}

void InputDeviceElement::SetScaledMax(long max)
{
    scaledMax = max;
}

long InputDeviceElement::GetSize(void)
{
    return size;
}

void InputDeviceElement::SetSize(long theSize)
{
    size = theSize;
}
        
Boolean InputDeviceElement::IsRelative(void)
{
    return isRelative;
}

void InputDeviceElement::SetRelative(Boolean relativeValue)
{
    isRelative = relativeValue;
}
        
Boolean InputDeviceElement::IsWrapping(void)
{
    return isWrapping;
}

void InputDeviceElement::SetWrapping(Boolean wrappingValue)
{
    isWrapping = wrappingValue;
}

Boolean InputDeviceElement::IsNonLinear(void)
{
    return isNonLinear;
}

void InputDeviceElement::SetNonLinear(Boolean nonLinearValue)
{
    isNonLinear = nonLinearValue;
}

Boolean InputDeviceElement::HasPreferredState(void)
{
    return hasPreferredState;
}

void InputDeviceElement::SetPreferredState(Boolean preferredStateValue)
{
    hasPreferredState = preferredStateValue;
}

Boolean InputDeviceElement::HasNullState(void)
{
    return hasNullState;
}

void InputDeviceElement::SetNullState(Boolean nullStateValue)
{
    hasNullState = nullStateValue;
}
  
long InputDeviceElement::GetUnits(void)
{
    return units;
}

void InputDeviceElement::SetUnits(long unitValue)
{
    units = unitValue;
}
        
long InputDeviceElement::GetUnitExponent(void)
{
    return unitExponent;
}

void InputDeviceElement::SetUnitExponent(long exponentValue)
{
    unitExponent = exponentValue;        
}

// Other functions
void InputDeviceElement::StoreElementData(CFTypeRef theElement)
{
    // Getting the information about an element
    // out of the HID Manager is a royal pain in the butt.
    // This function calls a ton of small functions to
    // fill the element data structure in a relatively
    // simple matter.  They convert the element data
    // from Core Foundation data types to types we can use.
    
    StoreCookieData(theElement);
    StoreTypeData(theElement);
    StoreUsagePageData(theElement);
    StoreUsageData(theElement);
    StoreRawMinData(theElement);
    StoreRawMaxData(theElement);
    StoreScaledMinData(theElement);
    StoreScaledMaxData(theElement);
    StoreSizeData(theElement);
    StoreIsRelativeData(theElement);
    StoreIsWrappingData(theElement);
    StoreIsNonLinearData(theElement);
    StoreHasPreferredStateData(theElement);
    StoreHasNullStateData(theElement);
    StoreUnitsData(theElement);
    StoreUnitExponentData(theElement);
    StoreElementNameData(theElement);
}

void InputDeviceElement::StoreCookieData(CFTypeRef theElement)
{
    CFTypeRef elementProperty;
    
    elementProperty = CFDictionaryGetValue((CFDictionaryRef)theElement, 
            CFSTR(kIOHIDElementCookieKey));
    
    if (elementProperty == nil)
        return;
        
    long cookieValue;
    CFNumberGetValue((CFNumberRef)elementProperty, kCFNumberLongType, &cookieValue);
    
    SetCookie((IOHIDElementCookie)cookieValue);
}

void InputDeviceElement::StoreTypeData(CFTypeRef theElement)
{
    CFTypeRef elementProperty;
    elementProperty = CFDictionaryGetValue((CFDictionaryRef)theElement, 
            CFSTR(kIOHIDElementTypeKey));
    
    if (elementProperty == nil)
        return;

    long typeValue;
    CFNumberGetValue((CFNumberRef)elementProperty, kCFNumberLongType, &typeValue);
    
    SetType((IOHIDElementType)typeValue);

}

void InputDeviceElement::StoreUsagePageData(CFTypeRef theElement)
{
    CFTypeRef elementProperty;
    elementProperty = CFDictionaryGetValue((CFDictionaryRef)theElement, 
            CFSTR(kIOHIDElementUsagePageKey));
    
    if (elementProperty == nil)
        return;

    long usagePageValue;
    CFNumberGetValue((CFNumberRef)elementProperty, kCFNumberLongType, &usagePageValue);
    
    SetUsagePage(usagePageValue);

}

void InputDeviceElement::StoreUsageData(CFTypeRef theElement)
{
    CFTypeRef elementProperty;
    elementProperty = CFDictionaryGetValue((CFDictionaryRef)theElement, 
            CFSTR(kIOHIDElementUsageKey));
    
    if (elementProperty == nil)
        return;

    long usageValue;
    CFNumberGetValue((CFNumberRef)elementProperty, kCFNumberLongType, &usageValue);
    
    SetUsage(usageValue);

}

void InputDeviceElement::StoreRawMinData(CFTypeRef theElement)
{
    CFTypeRef elementProperty;
    elementProperty = CFDictionaryGetValue((CFDictionaryRef)theElement, 
            CFSTR(kIOHIDElementMinKey));
    
    if (elementProperty == nil)
        return;
        
    long rawMinValue;
    CFNumberGetValue((CFNumberRef)elementProperty, kCFNumberLongType, &rawMinValue);
    
    SetRawMin(rawMinValue);
}

void InputDeviceElement::StoreRawMaxData(CFTypeRef theElement)
{
    CFTypeRef elementProperty;
    elementProperty = CFDictionaryGetValue((CFDictionaryRef)theElement, 
            CFSTR(kIOHIDElementMaxKey));
    
    if (elementProperty == nil)
        return;
        
    long rawMaxValue;
    CFNumberGetValue((CFNumberRef)elementProperty, kCFNumberLongType, &rawMaxValue);
    
    SetRawMax(rawMaxValue);

}

void InputDeviceElement::StoreScaledMinData(CFTypeRef theElement)
{
    CFTypeRef elementProperty;
    elementProperty = CFDictionaryGetValue((CFDictionaryRef)theElement, 
            CFSTR(kIOHIDElementScaledMinKey));
    
    if (elementProperty == nil)
        return;
        
    long scaledMinValue;
    CFNumberGetValue((CFNumberRef)elementProperty, kCFNumberLongType, &scaledMinValue);
    
    SetScaledMin(scaledMinValue);

}

void InputDeviceElement::StoreScaledMaxData(CFTypeRef theElement)
{
    CFTypeRef elementProperty;
    elementProperty = CFDictionaryGetValue((CFDictionaryRef)theElement, 
            CFSTR(kIOHIDElementScaledMaxKey));
    
    if (elementProperty == nil)
        return;
        
    long scaledMaxValue;
    CFNumberGetValue((CFNumberRef)elementProperty, kCFNumberLongType, &scaledMaxValue);
    
    SetScaledMax(scaledMaxValue);

}

void InputDeviceElement::StoreSizeData(CFTypeRef theElement)
{
    CFTypeRef elementProperty;
    elementProperty = CFDictionaryGetValue((CFDictionaryRef)theElement, 
            CFSTR(kIOHIDElementSizeKey));
    
    if (elementProperty == nil)
        return;
        
    long sizeValue;
    CFNumberGetValue((CFNumberRef)elementProperty, kCFNumberLongType, &sizeValue);
    
    SetSize(sizeValue);

}

void InputDeviceElement::StoreIsRelativeData(CFTypeRef theElement)
{
    CFTypeRef elementProperty;
    elementProperty = CFDictionaryGetValue((CFDictionaryRef)theElement, 
            CFSTR(kIOHIDElementIsRelativeKey));
    
    if (elementProperty == nil)
        return;

    Boolean isRelativeValue;
    isRelativeValue = CFBooleanGetValue((CFBooleanRef)elementProperty);
    
    SetRelative(isRelativeValue);
}

void InputDeviceElement::StoreIsWrappingData(CFTypeRef theElement)
{
    CFTypeRef elementProperty;
    elementProperty = CFDictionaryGetValue((CFDictionaryRef)theElement, 
            CFSTR(kIOHIDElementIsWrappingKey));
    
    if (elementProperty == nil)
        return;

    Boolean isWrappingValue;
    isWrappingValue = CFBooleanGetValue((CFBooleanRef)elementProperty);
    
    SetWrapping(isWrappingValue);

}

void InputDeviceElement::StoreIsNonLinearData(CFTypeRef theElement)
{
    CFTypeRef elementProperty;
    elementProperty = CFDictionaryGetValue((CFDictionaryRef)theElement, 
            CFSTR(kIOHIDElementIsNonLinearKey));
    
    if (elementProperty == nil)
        return;

    Boolean isNonLinearValue;
    isNonLinearValue = CFBooleanGetValue((CFBooleanRef)elementProperty);
    
    SetNonLinear(isNonLinearValue);

}

void InputDeviceElement::StoreHasPreferredStateData(CFTypeRef theElement)
{
    CFTypeRef elementProperty;
    elementProperty = CFDictionaryGetValue((CFDictionaryRef)theElement, 
            CFSTR(kIOHIDElementHasPreferredStateKey));
    
    if (elementProperty == nil)
        return;

    Boolean hasPreferredStateValue;
    hasPreferredStateValue = CFBooleanGetValue((CFBooleanRef)elementProperty);
    
    SetPreferredState(hasPreferredStateValue);

}

void InputDeviceElement::StoreHasNullStateData(CFTypeRef theElement)
{
    CFTypeRef elementProperty;
    elementProperty = CFDictionaryGetValue((CFDictionaryRef)theElement, 
            CFSTR(kIOHIDElementHasNullStateKey));
    
    if (elementProperty == nil)
        return;

    Boolean hasNullStateValue;
    hasNullStateValue = CFBooleanGetValue((CFBooleanRef)elementProperty);
    
    SetNullState(hasNullStateValue);

}

void InputDeviceElement::StoreUnitsData(CFTypeRef theElement)
{
    CFTypeRef elementProperty;
    elementProperty = CFDictionaryGetValue((CFDictionaryRef)theElement, 
            CFSTR(kIOHIDElementUnitKey));
    
    if (elementProperty == nil)
        return;
        
    long unitsValue;
    CFNumberGetValue((CFNumberRef)elementProperty, kCFNumberLongType, &unitsValue);
    
    SetUnits(unitsValue);

}

void InputDeviceElement::StoreUnitExponentData(CFTypeRef theElement)
{
    CFTypeRef elementProperty;
    elementProperty = CFDictionaryGetValue((CFDictionaryRef)theElement, 
            CFSTR(kIOHIDElementUnitExponentKey));
    
    if (elementProperty == nil)
        return;
        
    long unitExponentValue;
    CFNumberGetValue((CFNumberRef)elementProperty, kCFNumberLongType, &unitExponentValue);
    
    SetUnitExponent(unitExponentValue);

}

void InputDeviceElement::StoreElementNameData(CFTypeRef theElement)
{
    CFTypeRef elementProperty;
    elementProperty = CFDictionaryGetValue((CFDictionaryRef)theElement, 
            CFSTR(kIOHIDElementNameKey));
    
    if (elementProperty == nil) {
        StoreElementNameFromResource();
        return;
    }

    Str255 elementNameValue;
    //CFStringGetPascalString(elementProperty, elementNameValue, 256, 
    //                    CFStringGetSystemEncoding());

    CFStringEncoding systemEncoding = CFStringGetSystemEncoding();
    CFIndex stringLength = 256;
    Boolean conversionSuccess = CFStringGetPascalString((CFStringRef)elementProperty, 
                    (StringPtr)&elementNameValue, stringLength, systemEncoding);
    if (!conversionSuccess)
        return;
                        
    elementName = elementNameValue;
}

void InputDeviceElement::StoreElementNameFromResource(void)
{
    // If the game controller's drivers do not include element
    // names, we must generate an element name from the
    // element's usage page and usage.  I stored strings for
    // the element names in an STR# resource.  This function
    // reads the element's usage page and usage and sets the
    // element name accordingly.
    
    // This function assumes that the usage page and usage for
    // the element have already been set.
    short resourceID;
    
    if (GetUsagePage() == kGenericDesktopPage)
        resourceID = kGenericDesktopStringListID;
    else if (GetUsagePage() == kButtonPage)
        resourceID = kButtonStringListID;
    else
        return;
        
    GetIndString(elementName, resourceID, GetUsage());
}
