// InputDevice.h	by Mark Szymczyk

#ifndef __CARBON__
    #include <Carbon/Carbon.h>
#endif

#ifndef __COREFOUNDATION__
    #include <CoreFoundation/CoreFoundation.h>
#endif

#ifndef _IOKIT_HID_IOHIDLIB_H_
    #include <IOKit/hid/IOHIDLib.h>
#endif

#ifndef _IOKIT_HID_IOHIDKEYS_H_
    #include <IOKit/hid/IOHIDKeys.h>
#endif

#ifndef _IOKIT_IOKITLIB_H
    #include <IOKit/IOKitLib.h>
#endif

//#ifndef _IOKIT_IOHIDLIB_H
//    #include <IOKit/hidsystem/IOHIDLib.h>
//#endif

#ifndef _IOKIT_IOCFPLUGIN_H_
    #include <IOKit/IOCFPlugin.h>
#endif

#define INPUT_DEVICE

// The InputDevice class contains all the data fields
// for a HID Manager input device.  You may not
// need to be concerned with every field, but they are all
// here if you need them.

class InputDevice
{
    public:
        // I have to make the string members public
        // because C functions cannnot return arrays,
        // which strings are in C and C++.
        Str255 transport;
        Str255 manufacturer;
        Str255 productName;
        Str255 serialNumber;
    
    protected:
        io_object_t deviceObject;
        long vendorID;
        long productID;
        long version;
        long USBLocationID;
        long usagePage;
        long usage;
        
        
    public:
        // Constructor and destructor
        InputDevice(void);
        virtual ~InputDevice(void);
        
        // Accessors
        io_object_t GetDeviceObject(void);
        void SetDeviceObject(io_object_t theObject);
        
        long GetVendorID(void);
        void SetVendorID(long theID);

        long GetProductID(void);
        void SetProductID(long theID);

        long GetVersion(void);
        void SetVersion(long theVersion);

        long GetUSBLocationID(void);
        void SetUSBLocationID(long theID);

        long GetUsage(void);
        void SetUsage(long theUsage);

        long GetUsagePage(void);
        void SetUsagePage (long theUsagePage);
        
        // Core Foundation conversion functions.
        // We need these function so we can use the device data.
        void StoreDeviceData (CFTypeRef theDevice);
        
        void StoreTransportData(CFTypeRef theDevice);
        void StoreManufacturerData(CFTypeRef theDevice);
        void StoreProductNameData(CFTypeRef theDevice);
        void StoreSerialNumberData(CFTypeRef theDevice);
        void StoreVendorIDData(CFTypeRef theDevice);
        void StoreProductIDData(CFTypeRef theDevice);
        void StoreVersionData(CFTypeRef theDevice);
        void StoreUSBLocationIDData(CFTypeRef theDevice);
        void StoreUsagePageData(CFTypeRef theDevice);
        void StoreUsageData(CFTypeRef theDevice);
};

typedef InputDevice* InputDevicePtr;
typedef InputDevice** InputDeviceHandle;