// InputController.cp	by Mark Szymczyk
// Book version

#ifndef INPUT_DEVICE
    #include "InputDevice.h"
#endif

// Constructor
InputDevice::InputDevice(void)
{

}

// Destructor
InputDevice::~InputDevice(void)
{

}


// Accessors
io_object_t InputDevice::GetDeviceObject(void)
{
    return deviceObject;
}

void InputDevice::SetDeviceObject(io_object_t theObject)
{
    deviceObject = theObject;
}

long InputDevice::GetVendorID(void)
{
    return vendorID;
}

void InputDevice::SetVendorID(long theID)
{
    vendorID = theID;
}

long InputDevice::GetProductID(void)
{
    return productID;
}

void InputDevice::SetProductID(long theID)
{
    productID = theID;    
}

long InputDevice::GetVersion(void)
{
    return version;
}

void InputDevice::SetVersion(long theVersion)
{
    version = theVersion;
}

long InputDevice::GetUSBLocationID(void)
{
    return USBLocationID;
}

void InputDevice::SetUSBLocationID(long theID)
{
    USBLocationID = theID;
}

long InputDevice::GetUsage(void)
{
    return usage;
}

void InputDevice::SetUsage(long theUsage)
{
    usage = theUsage;
}

long InputDevice::GetUsagePage(void)
{
    return usagePage;
}

void InputDevice::SetUsagePage (long theUsagePage)
{
    usagePage = theUsagePage;
}


// Core Foundation conversion functions.
// These functions convert the device data from
// Core Foundation data types to types we can use.
void InputDevice::StoreDeviceData (CFTypeRef theDevice)
{
    StoreTransportData(theDevice);
    StoreManufacturerData(theDevice);
    StoreProductNameData(theDevice);
    StoreSerialNumberData(theDevice);
    StoreVendorIDData(theDevice);
    StoreProductIDData(theDevice);
    StoreVersionData(theDevice);
    StoreUSBLocationIDData(theDevice);
    StoreUsageData(theDevice);
    StoreUsagePageData(theDevice);
}

void InputDevice::StoreTransportData(CFTypeRef theDevice)
{
    CFTypeRef deviceProperty;
    deviceProperty = CFDictionaryGetValue((CFDictionaryRef)theDevice, 
            CFSTR(kIOHIDTransportKey));
    
    if (deviceProperty == nil)
        return;

    Str255 transportValue;
    CFStringEncoding systemEncoding = CFStringGetSystemEncoding();
    CFIndex stringLength = 256;
    
    Boolean conversionSuccess = CFStringGetPascalString((CFStringRef)deviceProperty, 
                    (StringPtr)&transportValue, stringLength, systemEncoding);
    if (!conversionSuccess)
        return;
                        
    transport = transportValue;
    
}

void InputDevice::StoreManufacturerData(CFTypeRef theDevice)
{
    CFTypeRef deviceProperty;
    deviceProperty = CFDictionaryGetValue((CFDictionaryRef)theDevice, 
            CFSTR(kIOHIDManufacturerKey));
    
    if (deviceProperty == nil)
        return;

    Str255 manufacturerValue;
    CFStringEncoding systemEncoding = CFStringGetSystemEncoding();
    CFIndex stringLength = 256;
    
    Boolean conversionSuccess = CFStringGetPascalString((CFStringRef)deviceProperty, 
                    (StringPtr)&manufacturerValue, stringLength, systemEncoding);
    if (!conversionSuccess)
        return;
                        
    manufacturer = manufacturerValue;

}

void InputDevice::StoreProductNameData(CFTypeRef theDevice)
{
    CFTypeRef deviceProperty;
    deviceProperty = CFDictionaryGetValue((CFDictionaryRef)theDevice, 
            CFSTR(kIOHIDProductKey));
    
    if (deviceProperty == nil)
        return;

    Str255 productNameValue;
    CFStringEncoding systemEncoding = CFStringGetSystemEncoding();
    CFIndex stringLength = 256;
    
    Boolean conversionSuccess = CFStringGetPascalString((CFStringRef)deviceProperty, 
                    (StringPtr)&productNameValue, stringLength, systemEncoding);
    if (!conversionSuccess)
        return;
                        
    productName = productNameValue;

}

void InputDevice::StoreSerialNumberData(CFTypeRef theDevice)
{
    CFTypeRef deviceProperty;
    deviceProperty = CFDictionaryGetValue((CFDictionaryRef)theDevice, 
            CFSTR(kIOHIDSerialNumberKey));
    
    if (deviceProperty == nil)
        return;

    Str255 serialNumberValue;
    CFStringEncoding systemEncoding = CFStringGetSystemEncoding();
    CFIndex stringLength = 256;
    
    Boolean conversionSuccess = CFStringGetPascalString((CFStringRef)deviceProperty, 
                    (StringPtr)&serialNumberValue, stringLength, systemEncoding);
    if (!conversionSuccess)
        return;
                        
    serialNumber = serialNumberValue;

}

void InputDevice::StoreVendorIDData(CFTypeRef theDevice)
{
    CFTypeRef deviceProperty;
    deviceProperty = CFDictionaryGetValue((CFDictionaryRef)theDevice, 
            CFSTR(kIOHIDVendorIDKey));
    
    if (deviceProperty == nil)
        return;

    long vendorIDValue;
    CFNumberGetValue((CFNumberRef)deviceProperty, kCFNumberLongType, &vendorIDValue);
    
    SetVendorID(vendorIDValue);

}

void InputDevice::StoreProductIDData(CFTypeRef theDevice)
{
    CFTypeRef deviceProperty;
    deviceProperty = CFDictionaryGetValue((CFDictionaryRef)theDevice, 
            CFSTR(kIOHIDProductIDKey));
    
    if (deviceProperty == nil)
        return;

    long productIDValue;
    CFNumberGetValue((CFNumberRef)deviceProperty, kCFNumberLongType, &productIDValue);
    
    SetProductID(productIDValue);

}

void InputDevice::StoreVersionData(CFTypeRef theDevice)
{
    CFTypeRef deviceProperty;
    deviceProperty = CFDictionaryGetValue((CFDictionaryRef)theDevice, 
            CFSTR(kIOHIDVersionNumberKey));
    
    if (deviceProperty == nil)
        return;

    long versionValue;
    CFNumberGetValue((CFNumberRef)deviceProperty, kCFNumberLongType, &versionValue);
    
    SetVersion(versionValue);

}

void InputDevice::StoreUSBLocationIDData(CFTypeRef theDevice)
{
    CFTypeRef deviceProperty;
    deviceProperty = CFDictionaryGetValue((CFDictionaryRef)theDevice, 
            CFSTR(kIOHIDLocationIDKey));
    
    if (deviceProperty == nil)
        return;

    long USBLocationIDValue;
    CFNumberGetValue((CFNumberRef)deviceProperty, kCFNumberLongType, &USBLocationIDValue);
    
    SetUSBLocationID(USBLocationIDValue);

}

void InputDevice::StoreUsagePageData(CFTypeRef theDevice)
{
    CFTypeRef deviceProperty;
    deviceProperty = CFDictionaryGetValue((CFDictionaryRef)theDevice, 
            CFSTR(kIOHIDPrimaryUsagePageKey));
    
    if (deviceProperty == nil)
        return;

    long usagePageValue;
    CFNumberGetValue((CFNumberRef)deviceProperty, kCFNumberLongType, &usagePageValue);
    
    SetUsagePage(usagePageValue);


}

void InputDevice::StoreUsageData(CFTypeRef theDevice)
{
    CFTypeRef deviceProperty;
    deviceProperty = CFDictionaryGetValue((CFDictionaryRef)theDevice, 
            CFSTR(kIOHIDPrimaryUsageKey));
    
    if (deviceProperty == nil)
        return;

    long usageValue;
    CFNumberGetValue((CFNumberRef)deviceProperty, kCFNumberLongType, &usageValue);
    
    SetUsage(usageValue);

}

