// InputController.h		Written by Mark Szymczyk
// Book version

#ifndef __CARBON__
    #include <Carbon/Carbon.h>
#endif

#ifndef __COREFOUNDATION__
    #include <CoreFoundation/CoreFoundation.h>
#endif

#ifndef _IOKIT_HID_IOHIDLIB_H_
    #include <IOKit/hid/IOHIDLib.h>
#endif

#ifndef _IOKIT_HID_IOHIDKEYS_H_
    #include <IOKit/hid/IOHIDKeys.h>
#endif

#ifndef _IOKIT_IOKITLIB_H
    #include <IOKit/IOKitLib.h>
#endif

//#ifndef _IOKIT_IOHIDLIB_H
//    #include <IOKit/hidsystem/IOHIDLib.h>
//#endif

#ifndef _IOKIT_IOCFPLUGIN_H_
    #include <IOKit/IOCFPlugin.h>
#endif

#ifndef INPUT_DEVICE
    #include "InputDevice.h"
#endif

#ifndef INPUT_DEVICE_ELEMENT
    #include "InputDeviceElement.h"
#endif

#ifndef LINKED_LIST
    #include "LinkedList.h"
#endif

#include <mach/mach.h>

#define INPUT_CONTROLLER

// Result Codes from Determine Action
enum InputControllerAction { 
	kNoMovement, 
    kNoButtonsPressed, 
    kMoveLeft, 
    kMoveUpAndLeft, 
    kMoveUp, 
    kMoveUpAndRight, 
    kMoveRight, 
	kMoveDownAndRight, 
    kMoveDown, 
    kMoveDownAndLeft, 
    kAttack,
    kChangeWeapon, 
    kPauseGame
};

// The virtual elements (1 for each need)
enum {
    kXAxisNeed = 0,
    kYAxisNeed, 
    kDirectionPadUpNeed,
    kDirectionPadDownNeed,
    kDirectionPadLeftNeed,
    kDirectionPadRightNeed,
    kAttackNeed, 
    kChangeWeaponNeed,
    kPauseGameNeed,
    kNumberOfNeeds
};

// Typedefs for some of the HID Manager types
typedef IOHIDDeviceInterface** IOHIDDeviceInterfaceHandle;
typedef IOHIDQueueInterface** IOHIDQueueInterfaceHandle;
typedef IOCFPlugInInterface** IOCFPlugInInterfaceHandle;


class InputController 
{
    public:
        IOHIDElementCookie gameNeeds[kNumberOfNeeds];
        
	protected:
        mach_port_t masterPort;
        LinkedList elementList;
        LinkedList controllerList;
        InputDevicePtr controllerDevice;
        
        IOHIDDeviceInterfaceHandle controllerDeviceInterface;
        IOHIDQueueInterfaceHandle eventList;

		short xAxisValue;
		short yAxisValue;
		
	public:
		InputController(void);
		~InputController(void);
		
		// Accessors
		short GetXAxisValue(void); 
		void SetXAxisValue(short x); 
		
		short GetYAxisValue(void); 
		void SetYAxisValue(short y);
        
        mach_port_t GetMasterPort(void);
        void SetMasterPort(mach_port_t thePort);
                        
        LinkedList GetElementList(void);
        void SetElementList(LinkedList theList);

        LinkedList GetControllerList(void);
        void SetControllerList(LinkedList theList);

        InputDevicePtr GetControllerDevice(void);
        void SetControllerDevice(InputDevicePtr theDevice);
        
        IOHIDDeviceInterfaceHandle GetControllerDeviceInterface(void);
        void SetControllerDeviceInterface(IOHIDDeviceInterfaceHandle theInterface);

        IOHIDQueueInterfaceHandle GetEventList(void);
        void SetEventList(IOHIDQueueInterfaceHandle theList);

		// Setup functions
        void Initialize(void);
        void Setup(void);
        
        // HID Manager initialization functions
        void CreateMasterPort(void);
        void CreateControllerList(void);
        void FillControllerList(io_iterator_t deviceList);
        void CreateElementList(io_object_t device);
        void FillElementList(CFTypeRef currentElement);
        static void AddElementToList(const void* value, void* parameter);
        void CreateDeviceInterface(void);
        void CreateEventList(void);
        void OpenDevice(void);

        // Setting default controllers
        void SetDefaultController(void);
        void SetDefaultControls(void);
        
		UInt32 GetNumberOfNeeds(void);
		void CleanUp(void);
        
        // HID Manager cleanup functions
        void DisposeEventList(void);
        void CloseDevice(void);
        void DisposeDeviceInterface(void);
        void DisposeElementList(void);
        void DisposeControllerList(void);
        void DisposeMasterPort(void);
        
		InputControllerAction DetermineAction(void);
		InputControllerAction DetermineDigitalMovement(void);
        InputControllerAction DetermineAnalogMovement(void);
		void Configure(void);
		void Pause(void);
		void Resume(void);

		// Utility Functions
		
        // This function checks to see whether or not the
        // player has any HID devices connected to his computer.
        Boolean AnyConnectedHIDDevices(void);
        
        SInt32 ConvertXAxisData(UInt32 axisValue, SInt32 minValue, SInt32 maxValue);
		SInt32 ConvertYAxisData(UInt32 axisValue, SInt32 minValue, SInt32 maxValue);		
        long GetMaximumXAxisValue(void);
        long GetMaximumYAxisValue(void);
};

typedef InputController* InputControllerPtr;
typedef InputController** InputControllerHandle;

// Constants
const short kEventListSize = 32;
const long kButtonDown = 1;
const long kButtonUp = 0;
const AbsoluteTime kZeroTime = {0,0};

// Axis related constants
// I initially wanted a range from
// -5 to 5, but in testing, I found that it made
// moving non-diagonally difficult.
const SInt32 kAxisMinimumValue = -5;
const SInt32 kAxisCenterValue = 0;
const SInt32 kAxisMaximumValue = 5;
