// GameWeapon.h 		by Mark Szymczyk

#ifndef GAME_SPRITE
	#include "GameSprite.h"
#endif

#define GAME_WEAPON

// I don't use the WeaponType data type in the game itself.
// WeaponType allows you to implement Dungeons and Dragons
// behavior where enemies can resist certain types
// of weapons.  Add, change, or delet your own weapon types to
// suit your game needs.
enum WeaponType {
	kEdgedWeapon,
	kBluntWeapon,
	kFlameWeapon
};

// Elements for the weapon list
enum {
	kCrossbowIndex = 0,
	kBoltIndex,
	kEnemyAttackIndex,
	kTotalNumberOfWeapons
};

class GameWeapon : public GameSprite
{
	protected:
		WeaponType weaponClass;
		short range;
		short damage;
        
        // For flying missiles, the initial force is high,
        // then gravity slows it down.  We must store the current
        // amount of force so gravity can slow it each frame.
        Vector2D currentForce;
		
	public:
		// Constructor and destructor
		GameWeapon(void);
		//GameWeapon(WeaponType theType, short theRange, short theDamage);
		virtual ~GameWeapon(void); 
		
		// Accessors
		WeaponType GetWeaponClass(void); 			
		void SetWeaponClass(WeaponType theClass);	
		
		short GetRange(void); 				
		void SetRange (short theRange);	
		
		short GetDamage(void); 			
		void SetDamage(short theDamage);	

        Vector2D GetCurrentForce(void);
        void SetCurrentForce(Vector2D forceValue);
        
        // Force related functions
        void CalculateInitialForce(SpriteDirection missileDirection);
        void CalculateCurrentForce(double timeStep);
        Boolean StoppedMoving(void);

		// Stuff to override
		virtual void DetermineSpriteToDraw(void);
        		
};

typedef GameWeapon* GameWeaponPtr;
typedef GameWeapon** GameWeaponHandle;

// Constants
const short kWeaponSpriteWidth = 32;
const short kWeaponSpriteHeight = 32;

const short kBoltWeaponRow = 0;

const short kWeaponUpColumn = 0;
const short kWeaponDownColumn = 1;
const short kWeaponLeftColumn = 2;
const short kWeaponRightColumn = 3;

const float kMissileDeceleration = -1.0;
const short kMissileMinSpeed = 0;

// Constants for weapon characteristics
const short kFistRange = 0;
const short kFistDamage = 1;

const short kCrossbowRange = 12;
const short kCrossbowDamage = 0;

const short kBoltRange = 12;
const short kBoltDamage = 4;
const short kBoltSpeed = 24;

const short kEnemyAttackRange = 0;
const short kEnemyAttackDamage = 10;

// Missile movement
const double kBoltMaxSpeed = 500.0;
const double kBoltMass = 1.0;
const double kBoltForceMagnitude = 1000.0;

const double kGravityAcceleration = -499.8;