// GameWeapon.cp		by Mark Szymczyk

#ifndef GAME_WEAPON
	#include "GameWeapon.h"
#endif

// Constructors
GameWeapon::GameWeapon(void) //: GameSprite()
{
	SetSpriteWidth(kWeaponSpriteWidth);
	SetSpriteHeight(kWeaponSpriteHeight);
    SetWeaponClass(kEdgedWeapon);
    SetRange(0);
    SetDamage(0);
    
    currentForce.SetXComponent(0.0);
    currentForce.SetYComponent(0.0);    
}

/*
GameWeapon::GameWeapon(WeaponType theType, short theRange, short theDamage)
{
    SetSpriteWidth(kWeaponSpriteWidth);
	SetSpriteHeight(kWeaponSpriteHeight);
	SetWeaponClass(theType);
	//SetRange(theRange);
	SetDamage(theDamage);
    
}
*/

// Destructor
GameWeapon::~GameWeapon(void)
{

}

// Accessors
WeaponType GameWeapon::GetWeaponClass(void) 			
{ 
    return weaponClass; 
}

void GameWeapon::SetWeaponClass(WeaponType theClass)	
{ 
    weaponClass = theClass; 
}

short GameWeapon::GetRange(void) 				
{ 
    return range; 
}

void GameWeapon::SetRange (short theRange)	
{ 
    range = theRange; 
}

short GameWeapon::GetDamage(void) 			
{ 
    return damage; 
}

void GameWeapon::SetDamage(short theDamage)	
{ 
    damage = theDamage; 
}

Vector2D GameWeapon::GetCurrentForce(void)
{
    return currentForce;
}

void GameWeapon::SetCurrentForce(Vector2D forceValue)
{
    currentForce = forceValue;
}


// Force related functions
void GameWeapon::CalculateInitialForce(SpriteDirection missileDirection)
{
    double xComponent;
    double yComponent;
    
    switch (missileDirection) {
		case kSpriteFacingUp:		
            xComponent = kStandingSpeed;
			yComponent = kBoltForceMagnitude * -1.0;
            break;
			
		case kSpriteFacingDown:
            xComponent = kStandingSpeed;			
			yComponent = kBoltForceMagnitude;
            break;

		case kSpriteFacingLeft:
			xComponent = kBoltForceMagnitude * -1.0;
            yComponent = kStandingSpeed;
			break;

		case kSpriteFacingRight:
			xComponent = kBoltForceMagnitude;
            yComponent = kStandingSpeed;			
			break;
			
		default:
			xComponent = kStandingSpeed;
            yComponent = kStandingSpeed;
			break;
	}
    
    currentForce.SetXComponent(xComponent);
    currentForce.SetYComponent(yComponent);
}

void GameWeapon::CalculateCurrentForce(double timeStep)
{
    // Apply gravity to the current force
    
    Vector2D gravityForce;
    
    double oldXComponent;
    double oldYComponent;
    
    oldXComponent = currentForce.GetXComponent();
    oldYComponent = currentForce.GetYComponent();
 
    double gravityMagnitude = kGravityAcceleration * GetMass() * timeStep;
    SpriteDirection missileDirection = GetSpriteDirection();
    
    switch (missileDirection) {
		case kSpriteFacingUp:		
            gravityForce.SetXComponent(kStandingSpeed);
			gravityForce.SetYComponent(gravityMagnitude * -1.0);
            break;
			
		case kSpriteFacingDown:
            gravityForce.SetXComponent(kStandingSpeed);
			gravityForce.SetYComponent(gravityMagnitude);
            break;

		case kSpriteFacingLeft:
			gravityForce.SetXComponent(gravityMagnitude * -1.0);
            gravityForce.SetYComponent(kStandingSpeed);
			break;

		case kSpriteFacingRight:
			gravityForce.SetXComponent(gravityMagnitude);
            gravityForce.SetYComponent(kStandingSpeed);
			break;
			
		default:
            gravityForce.SetXComponent(kStandingSpeed);
            gravityForce.SetYComponent(kStandingSpeed);
			break;
	}

    double newXComponent;
    double newYComponent;
    
    newXComponent = oldXComponent + gravityForce.GetXComponent();
    newYComponent = oldYComponent + gravityForce.GetYComponent();
    
    currentForce.SetXComponent(newXComponent);
    currentForce.SetYComponent(newYComponent);
}

Boolean GameWeapon::StoppedMoving(void)
{
    // Used for missile weapons

    SpriteDirection missileDirection = GetSpriteDirection();
    double xComponent = velocity.GetXComponent();
    double yComponent = velocity.GetYComponent();
    
    switch (missileDirection) {
		case kSpriteFacingUp:		
            // Upward velocities are less than 0
            if (yComponent > kStandingSpeed)
                return true;
            else
                return false;
            break;
			
		case kSpriteFacingDown:
            // Downward velocities are greater than 0
            if (yComponent < kStandingSpeed)
                return true;
            else
                return false;
            break;

		case kSpriteFacingLeft:
            // Left velocities are less than 0
            if (xComponent > kStandingSpeed)
                return true;
            else
                return false;
			break;

		case kSpriteFacingRight:
            // Right velocities are greater than 0
            if (xComponent < kStandingSpeed)
                return true;
            else
                return false;
			break;
			
		default:
			return false;
            break;
	}
 
    return false;   
}


// Other functions
void GameWeapon::DetermineSpriteToDraw(void)
{
	switch (direction) {
		case kSpriteFacingUp:
			SetSpriteColumn(kWeaponUpColumn);
			break;
			
		case kSpriteFacingDown:
			SetSpriteColumn(kWeaponDownColumn);
			break;

		case kSpriteFacingLeft:
			SetSpriteColumn(kWeaponLeftColumn);
			break;

		case kSpriteFacingRight:
			SetSpriteColumn(kWeaponRightColumn);
			break;
			
		default:
			break;
	}
    
    SetSpriteRow(kBoltWeaponRow);
}

