// GameTile.h		Written by Mark Szymczyk
// Book Version


#ifndef __CARBON__
    #include <Carbon/Carbon.h>
#endif

// We need the GameLevel.h file for
// the SeriousError() function when reading resources.
#ifndef GAME_LEVEL
	#include "GameLevel.h"
#endif

#define GAME_TILE

// enumerate the tile attributes
enum GameTileType
{
	kWallTile = 1, 
	kFloorTile, 
	kDoorTile,
	kTrapTile,
	kForegroundTile,
	kEntranceTile, 
	kExitTile
};	


class GameTile
{
	protected:
		short tileNumber;
		GameTileType tileType;
		
	public:
		short GetTileNumber(void);
		void SetTileNumber(short theNumber);

		GameTileType GetTileType(void);
		void SetTileType(GameTileType theType);
		
};


const short kMaxTiles = 500; //300;

class GameTileList 
{
	public: 
		GameTile tileTable[kMaxTiles];
		
	public:
		Boolean ReadTilesFromDisk(short tileID);
		short GetTileNumber(Point location);
		Point GetGridLocation(short tileNumber);

};

typedef GameTileList* GameTileListPtr;
typedef GameTileList** GameTileListHandle;

// Constants
const short k1BitColor = 1;
const short k2bitColor = 2;
const short k4BitColor = 4;
const short k8BitColor = 8;
const short k16BitColor = 16;
const short k32BitColor = 32;
const short kStandardWidth = 800; //640;
const short kStandardHeight = 640; //480;
const short kPictFileHeaderSize = 512;
const short kTilesInRow = 25; //20;	// 25 32X32 pixels per 800 pixel row

const Str255 kTileBoardName = "/pTile Window tile board PICT";
const Str255 kTileTypeListName = "/pTile Window tile type list";
const Str255 kInsertionPointName = "/pTile window insertion point";

// resource type constants
const short kTileResourceID = 201;
const short kTilePictureID = 201;
const OSType kTileFileType = 'Tilw';
const ResType kRectResourceType = 'Rect';
const ResType kTileResourceType = 'Tile';
const short kCurrentTileVersion = 1;
		