// GameTile.cp		Written by Mark Szymczyk
// Book Version

#ifndef GAME_TILE
	#include "GameTile.h"
#endif

short GameTile::GetTileNumber(void)
{
	return tileNumber;
}
		
void GameTile::SetTileNumber(short theNumber)
{
	tileNumber = theNumber;
}

GameTileType GameTile::GetTileType(void)
{
	return tileType;
}


void GameTile::SetTileType(GameTileType theType)
{
	tileType = theType;
}



Boolean GameTileList::ReadTilesFromDisk(short tileID)
{
	short error;
	//short refNum;
	Handle savedTileTypeList;
			
	savedTileTypeList = GetResource(kTileResourceType, tileID);
	error = ResError();
	if ((error != noErr) || (savedTileTypeList == nil))
		return false;

	// Check to make sure our resource is the current version
	short version;
	Size offset = 0;
	BlockMoveData(*savedTileTypeList + offset, &version, sizeof(short));
	offset = offset + sizeof(short);

	// If resource is obsolete, don't load it.
	if (version != kCurrentTileVersion) {
		ReleaseResource((Handle)savedTileTypeList);
		//CloseResFile(refNum);
		return false;
	}
		
	// Now let's fill the tileTypeList array
	BlockMoveData(*savedTileTypeList + offset, tileTable, sizeof(tileTable));
	error = MemError();
	if (SeriousError(error))
		return false;	 
	
	// Clean up
	ReleaseResource(Handle(savedTileTypeList));
	error = ResError();
	if (SeriousError(error))
		return false;
	
	return true;
}

short GameTileList::GetTileNumber(Point location)
{
	short rowNumber = location.v;
	short columnNumber = location.h;
	
	short result = (rowNumber * kTilesInRow) + columnNumber;
	
	return result;
}

Point GameTileList::GetGridLocation(short tileNumber)
{
	// Given a tile number from the level map, return
	// the grid location of the tile on the tile board.
	Point result;
	
	result.h = tileNumber % kTilesInRow;
	result.v = tileNumber / kTilesInRow;
	
	return result;
}

