// GameSprite.h		Written by Mark Szymczyk
// Book version


#ifndef GAME_CONTEXT
	#include "GameContext.h"
#endif

#ifndef BLITTER
	#include "Blitter.h"
#endif

#ifndef GAME_LEVEL
	#include "GameLevel.h"
#endif

#ifndef GAME_TILE
	#include "GameTile.h"
#endif

#ifndef VECTOR_2D
	#include "Vector2D.h"
#endif

#ifndef __CARBON__
    #include <Carbon/Carbon.h>
#endif


#define GAME_SPRITE

// enumerate the directions
enum SpriteDirection {
	kSpriteFacingUp = 1, 
	kSpriteFacingDown, 
	kSpriteFacingLeft, 
	kSpriteFacingRight
};	

// enumerate possible actions 
enum SpriteAction {
    kSpriteStanding, 
    kSpriteMoving, 
    kSpriteFighting
};


class GameSprite 
{
	protected:
		// Still need worldX and worldY for sprite drawing
		short worldX;
		short worldY;
		
		// Linear motion variables
		Vector2D position;
		Vector2D velocity;			// Measured in pixels per second
		Vector2D acceleration;		// Measured in pixels per second squared
		
		// Angular motion variables
		double orientation;
		double angularVelocity;
		double angularAcceleration;
		
		double mass;
		double maxSpeed;
		
		SpriteDirection direction;
		
		// Pointer to the buffer holding the entity's sprites
		GameOffscreenBufferPtr spriteStorage;
		GameContextPtr destination;
		
		short spriteRow;	// Where the sprite is in spriteStorage
		short spriteColumn;
		short spriteWidth;	// Width of sprites for the entity
		short spriteHeight;	
		
		SpriteAction action;			// The action the entity is performing
		short frame;		// For Multi-Frame actions
		
		Blitter spriteBlitter;
				
	public:
		GameSprite(void);
		virtual ~GameSprite(void);
		
		// Accessor functions
		short GetWorldX(void); 			
		void SetWorldX(short xValue);	
		
		short GetWorldY(void); 			
		void SetWorldY(short yValue);	

		Vector2D GetPosition(void); 					
		void SetPosition(Vector2D positionValue);	

		Vector2D GetVelocity(void); 					
		void SetVelocity(Vector2D velocityValue);	

		Vector2D GetAcceleration(void); 					
		void SetAcceleration(Vector2D accelerationValue);	

		double GetOrientation(void); 					
		void SetOrientation(double orientationValue);	

		double GetAngularVelocity(void); 					
		void SetAngularVelocity(double velocityValue);	

		double GetAngularAcceleration(void); 					
		void SetAngularAcceleration(double accelerationValue);	

		double GetMass(void); 					
		void SetMass(double massValue);	
		
		double GetMaxSpeed(void); 			
		void SetMaxSpeed(double speedValue); 

		SpriteDirection GetSpriteDirection(void); 				
		void SetSpriteDirection(SpriteDirection theDirection);	
		
		GameOffscreenBufferPtr GetSpriteStorage(void); 				
		void SetSpriteStorage(GameOffscreenBufferPtr storageLocation);	
		
		GameContextPtr GetDestination(void); 			
		void SetDestination(GameContextPtr theContext);	
		
		short GetSpriteRow(void); 			
		void SetSpriteRow(short rowValue);	
		
		short GetSpriteColumn(void); 			
		void SetSpriteColumn(short columnValue);	
		
		short GetSpriteWidth(void); 				
		void SetSpriteWidth(short widthValue);	
		
		short GetSpriteHeight(void); 			
		void SetSpriteHeight(short heightValue);	

		SpriteAction GetAction(void); 			
		void SetAction(SpriteAction theAction);	
		
		short GetFrame(void); 			
		void SetFrame(short theFrame);	

		Blitter GetSpriteBlitter(void); 				
		void SetSpriteBlitter(Blitter theBlitter);	
		
			
		// Drawing functions
		virtual short GetFramesInSequence(void); 
		virtual void DetermineSpriteToDraw(void); 
		void InitializeSpriteBlitter(void);
		void SetupSpriteBlitter(CGrafPtr destBuffer);
		void Draw(void);
		
		void SetupSourceRect(void);
		void SetupDestinationBuffer(CGrafPtr destBuffer);
		void SetupDestinationRect(void);
        void UpdateDirtyRectTable(void);

            
		// Utility functions

};

typedef GameSprite* GameSpritePtr;
typedef GameSprite** GameSpriteHandle;


// Constants
const short kStandFrame = 0;
const short kFirstFrame = 1;

const short kSpriteTransparencyValue = 0;

const short kBufferTopEdge = 0;
const short kBufferLeftEdge = 0;

const double kStandingSpeed = 0.0;
const double kRadicalTwoOverTwo = .7071067812;

const Boolean IsMovingDiagonally = true;
const Boolean IsNotMovingDiagonally = false;

// Sprite widths and heights

const short kPlayerSpriteWidth = 48;
const short kPlayerSpriteHeight = 48;

const short kPlayerMoveFrames = 11; //6;
const short kPlayerFightFrames = 6; //3;
const short kPlayerUpFrame = 0;
const short kPlayerDownFrame = 1;
const short kPlayerLeftFrame = 2;
const short kPlayerRightFrame = 3;
const short kPlayerStandFrame = 0;
const short kPlayerMoveFrame = 0;
const short kPlayerAttackFrame = 11; //7;


// Player movement
/*
const double kPlayerAcceleration = 1.0;
const double kPlayerMaxSpeed = 400.0;
const double kPlayerMass = 150.0;
*/
