// Sprite.cp	Written by Mark Szymczyk

#ifndef GAME_SPRITE
	#include "GameSprite.h"
#endif

// Constructor
GameSprite::GameSprite(void)
{
	SetWorldX(0);
	SetWorldY(0);
    
    position.SetXComponent(0.0);
    position.SetYComponent(0.0);
    
    velocity.SetXComponent(kStandingSpeed);
    velocity.SetYComponent(kStandingSpeed);

    acceleration.SetXComponent(kStandingSpeed);
    acceleration.SetYComponent(kStandingSpeed);

    SetOrientation(0.0);
    SetAngularVelocity(0.0);
    SetAngularAcceleration(0.0);
    SetMass(1.0);
    SetMaxSpeed(kStandingSpeed);
    
	direction = kSpriteFacingDown;
    spriteStorage = nil;
	destination = nil;
	
    SetSpriteRow(0);
	SetSpriteColumn(0);
	SetSpriteWidth(1);
	SetSpriteHeight(1);
	SetAction(kSpriteStanding);
	SetFrame(kStandFrame);
    
    // This is temporary.  Each individual creature will set its
    // own speed.  In this program, there's only the player.
    //SetMaxSpeed(kPlayerMaxSpeed);
}

// Destructor
GameSprite::~GameSprite(void)
{

}

// Accessor functions
short GameSprite::GetWorldX(void) 			
{ 
    return worldX;
}

void GameSprite::SetWorldX(short xValue)	
{ 
    worldX = xValue; 
}
		
short GameSprite::GetWorldY(void) 			
{ 
    return worldY; 
}

void GameSprite::SetWorldY(short yValue)	
{ 
    worldY = yValue; 
}

Vector2D GameSprite::GetPosition(void)
{
	return position;
}
 					
void GameSprite::SetPosition(Vector2D positionValue)
{
	position = positionValue;
}	

Vector2D GameSprite::GetVelocity(void)
{
	return velocity;
}
 					
void GameSprite::SetVelocity(Vector2D velocityValue)
{
	velocity = velocityValue;
}	

Vector2D GameSprite::GetAcceleration(void)
{
	return acceleration;
}
 					
void GameSprite::SetAcceleration(Vector2D accelerationValue)
{
	acceleration = accelerationValue;
}	

double GameSprite::GetOrientation(void)
{
	return orientation;
}
 					
void GameSprite::SetOrientation(double orientationValue)
{
	orientation = orientationValue;
}	

double GameSprite::GetAngularVelocity(void)
{
	return angularVelocity;
}
 					
void GameSprite::SetAngularVelocity(double velocityValue)
{
	angularVelocity = velocityValue;
}	

double GameSprite::GetAngularAcceleration(void)
{
	return angularAcceleration;
}
 					
void GameSprite::SetAngularAcceleration(double accelerationValue)
{
	angularAcceleration = accelerationValue;
}	

double GameSprite::GetMass(void)
{
	return mass;
}
 					
void GameSprite::SetMass(double massValue)
{
	mass = massValue;
}	
		
double GameSprite::GetMaxSpeed(void) 			
{ 
    return maxSpeed; 
}
		
void GameSprite::SetMaxSpeed(double speedValue) 
{ 
    maxSpeed = speedValue; 
}

SpriteDirection GameSprite::GetSpriteDirection(void) 				
{ 
    return direction; 
}
		
void GameSprite::SetSpriteDirection(SpriteDirection theDirection)	
{ 
    direction = theDirection; 
}
		
GameOffscreenBufferPtr GameSprite::GetSpriteStorage(void)	
{ 
    return spriteStorage; 
}
		
void GameSprite::SetSpriteStorage(GameOffscreenBufferPtr storageLocation)	
{ 
    spriteStorage = storageLocation; 
}
		
GameContextPtr GameSprite::GetDestination(void) 
{ 
    return destination; 
}
		
void GameSprite::SetDestination(GameContextPtr theContext)	
{ 
    destination = theContext; 
}
		
short GameSprite::GetSpriteRow(void) 			
{ 
    return spriteRow; 
}
		
void GameSprite::SetSpriteRow(short rowValue)	
{ 
    spriteRow = rowValue; 
}
		
short GameSprite::GetSpriteColumn(void) 			
{
    return spriteColumn; 
}

void GameSprite::SetSpriteColumn(short columnValue)	
{ 
    spriteColumn = columnValue; 
}
		
short GameSprite::GetSpriteWidth(void) 				
{ 
    return spriteWidth; 
}
		
void GameSprite::SetSpriteWidth(short widthValue)	
{ 
    spriteWidth = widthValue; 
}
		
short GameSprite::GetSpriteHeight(void) 			
{ 
    return spriteHeight; 
}
		
void GameSprite::SetSpriteHeight(short heightValue)	
{ 
    spriteHeight = heightValue; 
}

SpriteAction GameSprite::GetAction(void) 	
{ 
    return action; 
}
		
void GameSprite::SetAction(SpriteAction theAction)	
{ 
    action = theAction; 
}
		
short GameSprite::GetFrame(void) 			
{ 
    return frame; 
}
		
void GameSprite::SetFrame(short theFrame)	
{ 
    frame = theFrame; 
}

Blitter GameSprite::GetSpriteBlitter(void) 				
{ 
    return spriteBlitter; 
}
		
void GameSprite::SetSpriteBlitter(Blitter theBlitter)	
{ 
    spriteBlitter = theBlitter; 
}


// Drawing related functions
short GameSprite::GetFramesInSequence(void) 
{ 
	return 0;
    
    /*
    SpriteAction playerAction = GetAction();
	
	switch (playerAction) {
		case kSpriteMoving:
			return kPlayerMoveFrames;
			break;
			
		case kSpriteFighting:
			return kPlayerFightFrames;
			break;
			
		default:
			return 0;
	}
    */
}
		
void GameSprite::DetermineSpriteToDraw(void) 
{     
    
    SetSpriteRow(0);
    SetSpriteColumn(0);
    
    
	/*
    // Calculate sprite row
	short currentRow;
	
	switch (direction) {
		case kSpriteFacingUp:
			currentRow = kPlayerUpFrame;
			break;
			
		case kSpriteFacingDown:
			currentRow = kPlayerDownFrame;
			break;
			
		case kSpriteFacingLeft:
			currentRow = kPlayerLeftFrame;
			break;
			
		case kSpriteFacingRight:
			currentRow = kPlayerRightFrame;
			break;
			
		default:
			break;
		
	}

	SetSpriteRow(currentRow);
	
	// Now calculate sprite column
	short currentColumn;
	
	switch (action) {
		case kSpriteStanding:
			currentColumn = kPlayerStandFrame;
			break;
			
		case kSpriteMoving:	
			currentColumn = kPlayerMoveFrame + frame;
			break;
			
		case kSpriteFighting:
			currentColumn = kPlayerAttackFrame + frame;
			break;
			
		default:
			break;
			
	}

	SetSpriteColumn(currentColumn);
    */
}


void GameSprite::InitializeSpriteBlitter(void)
{
	// Sets up the parts of the sprite blitter that
	// stay the same from frame to frame.
    spriteBlitter.Initialize(spriteStorage->GetBufferStorage(), transparent);

}

void GameSprite::SetupSpriteBlitter(CGrafPtr destBuffer)
{
	// Sets up the parts of the sprite blitter that
	// change from frame to frame
	SetupSourceRect();
    SetupDestinationBuffer(destBuffer);
    SetupDestinationRect();
}

void GameSprite::Draw(void)
{
	spriteBlitter.DrawImageToOffscreenBuffer();
}

void GameSprite::SetupSourceRect(void)
{
	Rect sourceRect;
	sourceRect.top = (GetSpriteRow()) * (GetSpriteHeight());
	sourceRect.bottom = sourceRect.top + GetSpriteHeight();
	sourceRect.left = (GetSpriteColumn()) * (GetSpriteWidth());
	sourceRect.right = sourceRect.left + GetSpriteWidth();
	
	CGrafPtr sourceBuffer = spriteBlitter.GetSourceBuffer();
    Rect bufferRect;
    
    GetPortBounds(sourceBuffer, &bufferRect);

	// Bounds checking
	if (sourceRect.top < kBufferTopEdge) {
		
		// Move sprite to top edge
		sourceRect.top = kBufferTopEdge;
		sourceRect.bottom = sourceRect.top + GetSpriteHeight();
	}
	
	short bufferHeight = bufferRect.bottom - bufferRect.top;
	if (sourceRect.bottom > bufferHeight) {
		
		// Move sprite to bottom edge
		sourceRect.bottom = bufferRect.bottom;
		sourceRect.top = sourceRect.bottom - GetSpriteHeight();
	}
	
	if (sourceRect.left < kBufferLeftEdge) {
		
		// Move sprite to left edge
		sourceRect.left = kBufferLeftEdge;
		sourceRect.right = sourceRect.left + GetSpriteHeight();
	}
	
	short bufferWidth = bufferRect.right - bufferRect.left;	
	if (sourceRect.right > bufferWidth) {
		
		// Move sprite to right edge
		sourceRect.right = bufferRect.right;
		sourceRect.left = sourceRect.right - GetSpriteHeight();
	}
	
	spriteBlitter.SetSourceRect(sourceRect);

}

void GameSprite::SetupDestinationBuffer(CGrafPtr destBuffer)
{
	spriteBlitter.SetDestinationBuffer(destBuffer);
}



void GameSprite::SetupDestinationRect(void)
{
	Rect destRect;
	
    /*
    double xComponent = position.GetXComponent();
    double yComponent = position.GetYComponent();
    
    destRect.top = yComponent - (destination->GetVOffset() * kTileHeight);
	destRect.bottom = destRect.top + GetSpriteHeight();
	destRect.left = xComponent - (destination->GetHOffset() * kTileWidth);
	destRect.right = destRect.left + GetSpriteWidth();
    */
    
    
    destRect.top = GetWorldY() - (destination->GetVOffset() * kTileHeight);
	destRect.bottom = destRect.top + GetSpriteHeight();
	destRect.left = GetWorldX() - (destination->GetHOffset() * kTileWidth);
	destRect.right = destRect.left + GetSpriteWidth();
    
    
	CGrafPtr destBuffer = spriteBlitter.GetDestinationBuffer();
    Rect bufferRect;
    
    GetPortBounds(destBuffer, &bufferRect);

	// Bounds checking
    if (destRect.top < kBufferTopEdge) {
		
		// Move sprite to top edge
		destRect.top = kBufferTopEdge;
		destRect.bottom = destRect.top + GetSpriteHeight();
	}
	
	short bufferHeight = bufferRect.bottom - bufferRect.top;
	if (destRect.bottom > bufferHeight) {
		
		// Move sprite to bottom edge
		destRect.bottom = bufferRect.bottom;
		destRect.top = destRect.bottom - GetSpriteHeight();
	}
	
	if (destRect.left < kBufferLeftEdge) {
		
		// Move sprite to left edge
		destRect.left = kBufferLeftEdge;
		destRect.right = destRect.left + GetSpriteHeight();
	}
	
	short bufferWidth = bufferRect.right - bufferRect.left;	
	if (destRect.right > bufferWidth) {
		
		// Move sprite to right edge
		destRect.right = bufferRect.right;
		destRect.left = destRect.right - GetSpriteHeight();
	}
	
	spriteBlitter.SetDestinationRect(destRect);
} 

void GameSprite::UpdateDirtyRectTable(void)
{
	Rect dirtyRect; //= spriteBlitter.GetDestinationRect();
	
	dirtyRect.top = GetWorldY() - (destination->GetVOffset() * kTileHeight);
	dirtyRect.bottom = dirtyRect.top + GetSpriteHeight();
	dirtyRect.left = GetWorldX() - (destination->GetHOffset() * kTileWidth);
	dirtyRect.right = dirtyRect.left + GetSpriteWidth();
	 
    short leftEdge;
    short rightEdge;
    short topEdge;
    short bottomEdge;
    
    leftEdge = (dirtyRect.left / kTileWidth) - 1;
    rightEdge = (dirtyRect.right / kTileWidth) + 1;
    topEdge = (dirtyRect.top / kTileHeight) - 1;
    bottomEdge = (dirtyRect.bottom / kTileHeight) + 1;

	// Bounds checking for a sprite that is partially on screen
	// and partially off the screen.  I call 
	// AnimationController::IsInScreenArea() to
	// make sure the sprite is not totally off the screen before
	// calling this function.  It's dangerous not to do such a check because
	// an offscreen sprite would be outside the bounds of the 
	// dirty rectangle table and accessing it would probably
	// cause a crash.
	short rowsInTable = destination->GetScreenHeight() / kTileHeight;
	short columnsInTable = destination->GetScreenWidth() / kTileWidth;

	if (topEdge < 0)
		topEdge = 0;
		
	if (bottomEdge >= rowsInTable)
		bottomEdge = rowsInTable - 1;
		
	if (leftEdge < 0)
		leftEdge = 0;
		
	if (rightEdge >= columnsInTable)
		rightEdge = columnsInTable - 1;
		
	// Perform the update		    
    for (short row = topEdge; row <= bottomEdge; row++) {
        for (short column = leftEdge; column <= rightEdge; column++) {
            destination->MarkRectangleDirty(row, column);
        }
    }
}

// Utility functions
