// GameSound.h		by Mark Szymczyk
// Book Version

#ifndef __CARBON__
    #include <Carbon/Carbon.h>
#endif

#ifndef __CARBONSOUND__
    #include <CarbonSound/CarbonSound.h>
#endif

#define GAME_SOUND


class GameSound 
{
	protected:
		SndChannelPtr channel;
		SndListHandle soundData;
		Fixed sampleRate;	// Used for pausing and resuming sounds
		//Boolean soundPlaying;

		// Data members for playing a sound from an external file
		// using low-level Sound Manager routines
		Ptr buffer1;
		Ptr buffer2;
		ExtSoundHeaderPtr soundHeader;
		short soundFileRefNum;
		unsigned long startOfSoundData;
				
	public:
		
		GameSound(void);
		~GameSound(void);
		
		// Accessors
		SndChannelPtr GetChannel(void); 				
		void SetChannel(SndChannelPtr theChannel);	
		
		SndListHandle GetSoundData(void); 
		
		Boolean IsSoundPlaying(void);					//{ return soundPlaying; }
		//void SetSoundPlaying(Boolean isSoundPlaying)	{ soundPlaying = isSoundPlaying; }
		
		void Create(void);
		void CreateWithCallback(SndCallBackProcPtr theCallback);
		void ReadSoundData(short soundID);
		void Play(void);
		void PlayRepeatedly(void);
		static pascal void LoopSoundCallback(SndChannelPtr theChannel, SndCommand* theCommand);
		static pascal void DisposeSoundCallback(SndChannelPtr theChannel, SndCommand* theCommand);
		OSErr InstallCallback(void);
		void SetVolume(short leftVolume, short rightVolume);
		void Pause(void);
		void Resume(void);
		void Stop(void);
		void Dispose(void);
		void DisposeSoundData(void);
		
		// Functions for working with low-level sounds
		void PrepareToPlaySoundFile(Str255 filename, long bufferSize);		
		void PlayMultiBuffered(void);
		void AllocateBuffers(long bufferSize);
		void OpenSoundFile(Str255 filename);
		void FindStartOfSoundData(void);
		void InitializeSoundHeader(SoundComponentDataPtr soundInfo, unsigned long numberOfFrames);
		void ReadSoundData(Ptr soundBuffer);
		void QueueSoundFrame(void);
		static pascal void MultiBufferSoundCallback(SndChannelPtr theChannel, SndCommand* theCommand);
		void SwapBuffers(void);
		void DisposeLowLevelData(void);
		
};

typedef GameSound* GameSoundPtr;
typedef GameSound** GameSoundHandle;


// Constants
const Boolean kPlayAsynchronously = true;
const Boolean KDontPlayAsynchronously = false;
const Boolean kDisposeNow = true;
const short kSoundManagerID = 20;
const Fixed kNormalSampleRate = 0x00010000;
const Fixed kPauseSampleRate = 0x00000000;
const UInt16 kMaximumVolumeValue = 65535;
const short kFileNotOpen = -1;
 
// Sample size constants
const long k16KBuffer = 1024 * 16;
const long k32KBuffer = 1024 * 32;
const long k64KBuffer = 1024 * 64;
const long k128KBuffer = 1024 * 128;
const long k256KBuffer = 1024 * 256;
const long k512KBuffer = 1024 * 512;
