// GameSong.h	by Mark Szymczyk
// Book Version

// This is a class that uses
// QuickTime for sounds.  QuickTime is better
// for playing background music than sound effects,
// which is why I called the class GameSong.

#ifndef __CARBON__
    #include <Carbon/Carbon.h>
#endif

// Include QuickTime
#ifndef __MOVIES__
    #include <QuickTime/Movies.h>
#endif

#include <CoreFoundation/CoreFoundation.h>

#define GAME_SONG

class GameSong 
{
	protected:
		Movie soundToPlay;
		
	public:
		// Constructor
		GameSong(void);
		
		// Destructor
		~GameSong(void);
		
		// Accessors
		Movie GetSoundToPlay(void); 
		void SetSoundToPlay(Movie theSound); 
		
		static void StartQuickTime(void);
		void ReadSoundToPlay(Str255 filename /*FSSpec* soundFile*/, short soundID);
		//OSStatus CFURLGetFSSpec( CFURLRef url, FSSpec* outSpec );
        void ReadSoundFromResource (short soundID);
		void Play(void);
		void PlayRepeatedly(void);
		void Pause(void);
		void Resume(void);
		void Stop(void);
		void Dispose(void);
		static void ExitQuickTime(void);

};

// Non-member functions
//pascal void SoundCallback(SndChannelPtr theChannel, SndCommand theCommand);

typedef GameSong* GameSongPtr;
typedef GameSong** GameSongHandle;

// Constants
const ResType kMovieResourceType = 'moov';