// GameSong.cp	by Mark Szymczyk
// Book Version

// Functions for the GameSong Class

#ifndef GAME_SONG
	#include "GameSong.h"
#endif

// Constructor
GameSong::GameSong(void)
{

}

// Destructor
GameSong::~GameSong(void)
{
	Dispose();
}

// Accessors
Movie GameSong::GetSoundToPlay(void)
{ 
	return soundToPlay; 
}

void GameSong::SetSoundToPlay(Movie theSound)
{
	soundToPlay = theSound; 
}


void GameSong::StartQuickTime(void)
{
	EnterMovies();
}

void GameSong::ReadSoundToPlay(Str255 filename, short soundID)
{
	// Takes a file and converts it to a QuickTime
	// movie in memory.  The soundID is the resource ID for
	// the QuickTime movie.  If you use a soundID of 0, QuickTime
	// will load the first movie in the file.
	
	OSErr error;
	//OSStatus result;
    FSSpec soundFile;

    CFBundleRef gameBundle = CFBundleGetMainBundle();
    CFURLRef resourceFileLocation;
    
    CFStringRef resourceFileToFind; 
    resourceFileToFind = CFStringCreateWithPascalString(nil, filename, CFStringGetSystemEncoding());
    
    CFStringRef resourceFileType = nil;
    resourceFileLocation = CFBundleCopyResourceURL(gameBundle, resourceFileToFind,
        resourceFileType, nil); //kBundleNoSubDir);
    
    if (resourceFileLocation == nil)
        return;
        
    FSRef fileRef;
    Boolean success = CFURLGetFSRef(resourceFileLocation, &fileRef);
    
    if (!success)
        return;
        
    // Convert the FSRef to an FSSpec so we can call OpenMovieFile().
    // The first nil says we don't care about catalog info.
    // The second nil says we don't care about the file's name.
    // The third nil says we don't care about the parent directory.
    error = FSGetCatalogInfo(&fileRef, kFSCatInfoGettableInfo, nil, nil,
            &soundFile, nil);
    if (error != noErr)
        return;
        
    //result = CFURLGetFSSpec(resourceFileLocation, &soundFile);
	
	// The two zeroes tell the File Manager to
	// look in our applications directory for the file.
	//error = FSMakeFSSpec(0, 0, filename, &soundFile);
	//if (error != noErr)
	//	return;
		
	short soundFileRefNum;
	
	// Read the file from disk
	error = OpenMovieFile(&soundFile, &soundFileRefNum, fsRdPerm);
	
	if (error != noErr)
		return;
		
	// Now put it in memory.
	// The first nil says we don't care what the title of the movie is.
	// The second nil says we don't care if QuickTime
	// changed any data references.
	// The newMovieActive parameter tells QuickTime to make
	// the movie active.
    short fileID = movieInDataForkResID;
    error = NewMovieFromFile(&soundToPlay, soundFileRefNum, 
            &fileID, nil, newMovieActive, nil);
    
	// Now that we've loaded the movie into memory,
	// we can close the movie file.
	error = CloseMovieFile(soundFileRefNum);
    
    // Dispose of the Core Foundation memory we
    // allocated earlier in the function
    CFRelease(resourceFileToFind);
    CFRelease(resourceFileLocation);
}

/*
OSStatus GameSong::CFURLGetFSSpec( CFURLRef url, FSSpec* outSpec )
{
    CFIndex cBytes;
    BytePtr buffer;
    OSStatus error;
    CFStringRef path = CFURLCopyFileSystemPath( url, kCFURLHFSPathStyle );

    CFStringGetBytes( path, CFRangeMake( 0, CFStringGetLength( path ) ),
        kTextEncodingMacHFS,' ', false, NULL, 0, &cBytes );
    buffer = (BytePtr) NewPtr( cBytes );

    CFStringGetBytes( path, CFRangeMake( 0, CFStringGetLength( path ) ), 
        kTextEncodingMacHFS,' ', false, buffer, cBytes, &cBytes );

    error= FSpLocationFromFullPath( cBytes, buffer, outSpec );
    DisposePtr( (Ptr) buffer );
    return error;
}
*/

void GameSong::ReadSoundFromResource (short soundID)
{
	// Reads a QuickTime movie resource into memory.
	// The soundID is the resource ID for
	// the QuickTime movie.  If you use a soundID of 0, QuickTime
	// will load the first movie in the file.

	Handle soundData = Get1Resource(kMovieResourceType, soundID);
	if (soundData == nil)
		return;
		
	OSErr error;

	// The nil parameter says we don't care if QuickTime
	// changed any data references.
	// The newMovieActive parameter tells QuickTime to make
	// the movie active.
	error = NewMovieFromHandle(&soundToPlay, soundData, newMovieActive, nil);
}

void GameSong::Play(void)
{
	// Plays a sound one time
	StartMovie(soundToPlay);
}

void GameSong::PlayRepeatedly(void)
{
	// Loops a sound
	
	if (IsMovieDone(soundToPlay)) {
		GoToBeginningOfMovie(soundToPlay);
		StartMovie(soundToPlay);
	}
	
	// Give QuickTime the time it needs.
	// The value 0 tells QuickTime to determine
	// the amount of time it needs.
	MoviesTask(soundToPlay, 0);
}

void GameSong::Pause(void)
{
	StopMovie(soundToPlay);
}

void GameSong::Resume(void)
{
	StartMovie(soundToPlay);
}

void GameSong::Stop(void)
{
	StopMovie(soundToPlay);
	
	// Go back to start of movie so the movie
	// plays properly when the player plays
	// the game again
	GoToBeginningOfMovie(soundToPlay);
}

void GameSong::Dispose(void)
{
	Stop();
	DisposeMovie(soundToPlay);
}

void GameSong::ExitQuickTime(void)
{
	ExitMovies();
}