// GamePlayer.h		Written by Mark Szymczyk

#ifndef GAME_SPRITE
	#include "GameSprite.h"
#endif

#ifndef GAME_ITEM
	#include "GameItem.h"
#endif

#ifndef GAME_WEAPON
	#include "GameWeapon.h"
#endif

#define GAME_PLAYER

enum {
	kTraverseEveryTile = 1,
	kSkipOneTile,
	kSkipTwoTiles,
	kSkipThreeTiles,
	kSkipFourTiles,
	kSkipFiveTiles,
	kSkipSixTiles,
	kSkipSevenTiles,
	kSkipEightTiles
};

class GamePlayer : public GameSprite
{
	protected:
		short totalHitPoints;
		short currentHitPoints;
		long score;
		
		// I will make weapon and armor classes in the future
		GameWeapon currentWeapon;
		Rect viewRect;

		short ammo;
		
	public:
		// Constructor and destructor
        GamePlayer();
        ~GamePlayer();
		
		// Accessor functions
		short GetTotalHitPoints(void); 		
		void SetTotalHitPoints(short hp);	
		
		short GetCurrentHitPoints(void); 	
		void SetCurrentHitPoints(short hp); 	

		long GetScore(void); 
		void SetScore(long scoreValue); 

		GameWeapon GetCurrentWeapon(void); 					
		void SetCurrentWeapon(GameWeapon theWeapon); 	

		Rect GetViewRect(void); 			
		void SetViewRect(Rect theRect);	

		short GetAmmo(void); 			
		void SetAmmo(short ammoValue);	

		// View Rectangle functions
		void DetermineViewRect(GameLevelPtr theLevel, GameTileListPtr theTiles);

		short ComputeUpViewRect(GameLevelPtr theLevel, GameTileListPtr theTiles);
		short TraverseForSolidUp(short startX, short startY, GameLevelPtr theLevel, 
                GameTileListPtr theTiles, short threshold);
		short FindNearestSolidUp(short startX, short startY, GameLevelPtr theLevel, 
                GameTileListPtr theTiles, short skipValue);
		
		short ComputeDownViewRect(GameLevelPtr theLevel, GameTileListPtr theTiles);
		short TraverseForSolidDown(short startX, short startY, GameLevelPtr theLevel, 
                GameTileListPtr theTiles, short threshold);
		short FindNearestSolidDown(short startX, short startY, GameLevelPtr theLevel, 
                GameTileListPtr theTiles, short skipValue);

		short ComputeLeftViewRect(GameLevelPtr theLevel, GameTileListPtr theTiles);
		short TraverseForSolidLeft(short startX, short startY, GameLevelPtr theLevel, 
                GameTileListPtr theTiles, short threshold);
		short FindNearestSolidLeft(short startX, short startY, GameLevelPtr theLevel, 
                GameTileListPtr theTiles, short skipValue);

		short ComputeRightViewRect(GameLevelPtr theLevel, GameTileListPtr theTiles);
		short TraverseForSolidRight(short startX, short startY, GameLevelPtr theLevel, 
                GameTileListPtr theTiles, short threshold);
		short FindNearestSolidRight(short startX, short startY, GameLevelPtr theLevel, 
                GameTileListPtr theTiles, short skipValue);
				
		// Event related functions
		void HandleChangeWeapon(void);

		// Taking of items
		Boolean TakeItem(GameItemPtr theItem);
		Boolean TakeCrossbow(void);
		Boolean TakeBolts(void);
		Boolean TakeCoins(void);
		Boolean TakeGems(void);
		Boolean TakeHealingPotion(void);

		// Damage related functions
		void TakeHit(GameWeaponPtr weaponThatHit);
		Boolean WasKilled(void);
						
		// Miscellaneous and utility functions
		Boolean CanAttack(void);
		Boolean LowOnAmmo(void);
		void DetermineCurrentWeapon(void);
		void FireMissile(void);
		
		Boolean ReachedExit(GameLevelPtr theLevel, GameTileListPtr theTiles);
		
		short GetFramesInSequence(void);   	// Descended from Sprite
		void DetermineSpriteToDraw(void);	// Descended from Sprite
};

typedef GamePlayer* GamePlayerPtr;
typedef GamePlayer** GamePlayerHandle;

// Constants
const short kPlayerStartHP = 10;
const short kStartCrossbowAmmo = 50;
const short kIncrementCrossbowAmmo = 10;
const short kMaximumCrossbowAmmo = 100;
const short kCoinsScore = 500;
const short kGemsScore = 1000;

const short kHealingPotionHealingValue = 5;
const short kLowAmmoThreshold = 10;

// Player movement constants
const double kPlayerAcceleration = 1.0;
const double kPlayerMaxSpeed = 400.0;
const double kPlayerMass = 150.0;

// Player sprite constants
/*
const short kPlayerSpriteWidth = 48;
const short kPlayerSpriteHeight = 48;

const short kPlayerMoveFrames = 11; //6;
const short kPlayerFightFrames = 6; //3;
const short kPlayerUpFrame = 0;
const short kPlayerDownFrame = 1;
const short kPlayerLeftFrame = 2;
const short kPlayerRightFrame = 3;
const short kPlayerStandFrame = 0;
const short kPlayerMoveFrame = 1;
const short kPlayerAttackFrame = 12; //7;
*/
