// GameOffscreenBuffer.h		Written by Mark Szymczyk
// Book Version

// The GameOffscreenBuffer class is a wrapper
// for offscreen buffers.  Right now, we
// use GWorlds.


#ifndef __CARBON__
    #include <Carbon/Carbon.h>
#endif

#define GAME_OFFSCREEN_BUFFER

class GameOffscreenBuffer
{
	protected:
		GWorldPtr bufferStorage;
		
	public:
		GameOffscreenBuffer(void);
		
		// Accessor Functions
		GWorldPtr GetBufferStorage(void);
		void SetBufferStorage (GWorldPtr theStorage);	
		
		// Other functions we need
		Boolean Create(short width, short height, short colorDepth,
						CTabHandle colorTable, GWorldFlags flags);
		Boolean CreateInVRAM(short width, short height, short colorDepth,
						CTabHandle colorTable, GWorldFlags flags);
        Boolean CreatePICTSized(short pictureResourceID, short colorDepth,
                        CTabHandle colorTable, GWorldFlags flags);
		Boolean Update(short width, short height, short colorDepth,
						CTabHandle colorTable, GWorldFlags flags);
		
		void Dispose(void);
		void Draw(short pictureResourceID);
		short GetPixelValue(short row, short column);
		
};

typedef GameOffscreenBuffer* GameOffscreenBufferPtr;
typedef GameOffscreenBuffer** GameOffscreenBufferHandle;

// Constants 
const short kNoFlags = 0;
const short kUseCurrentColorDepth = 0;
const short kRowByteMask = 0x3FFF;