// GameLevel.h  Book Version		Written by Mark Szymczyk

#ifndef __CARBON__
    #include <Carbon/Carbon.h>
#endif

/*
#ifndef LINKED_LIST
    #include "LinkedList.h"
#endif

#ifndef GAME_ENEMY
	#include "GameEnemy.h"
#endif

#ifndef GAME_ITEM
	#include "GameItem.h"
#endif
*/

#define GAME_LEVEL

enum PopulationItem {
	kNoItem = 0,
	kEnemy = 1,
	kBolts,
	kCoins,
	kGems,
	kHealingPotion
};

class LevelResident
{
	protected:
		PopulationItem resident;
		short startX;
		short startY;
		
	public:
		// Constructor and destructor
		LevelResident(void);
        virtual ~LevelResident(void);
        
		// Accessors
		PopulationItem GetResident(void); 				
		void SetResident(PopulationItem theResident);	
		
		short GetStartX(void); 	
		void SetStartX(short x); 	
		
		short GetStartY(void); 	
		void SetStartY(short y);	
		
};

typedef LevelResident* LevelResidentPtr;
typedef LevelResident** LevelResidentHandle;

class MapElement
{
	protected:
		short value;	// The tile number
		Boolean visibleToPlayer;
		
	public:	
		short GetValue(void);  			
		void SetValue(short theValue);	
		
		Boolean IsVisibleToPlayer(void) ;				
		void SetVisibleToPlayer(Boolean visibility);	
};


typedef MapElement* MapElementPtr;
typedef MapElement** MapElementHandle;

class GameLevel
{
	public:
		// I'm making levelMap public to simplify access to it
		// in the LevelWindow class.  I'd like to make an easy
		// accessor function.
		MapElementPtr levelMap;	// Used as a 2D array
		
	protected:
		short levelWidth;		// in tiles
		short levelHeight;		// in tiles
		short tileID;			// Resource ID of the tiles this level uses
		
        //LinkedList enemyList;
        //LinkedList itemList;
        
	public:
		// constructor
		GameLevel(void);
		GameLevel(const GameLevel& theLevel);	// Copy constructor
		
		// Destructor
		~GameLevel(void);
		
		// Overload assignment operator
		GameLevel& operator= (const GameLevel& theLevel);

		void AllocateLevelMap(void);
		void DeleteLevelMap(void);
		void InitializeLevelMap (short value);
				
		// Accessor functions
		short GetLevelWidth(void);
		void SetLevelWidth(short width);
		short GetLevelHeight(void);
		void SetLevelHeight(short height);
		
		short GetTileID(void);
		void SetTileID(short theID);
	
        /*
        LinkedList GetEnemyList(void);
        void SetEnemyList(LinkedList theList);
        
        LinkedList GetItemList(void);
        void SetItemList(LinkedList theList);
		*/
        	
		// File related functions
		Boolean ReadLevelData(short levelID);
        //Boolean ReadLevelPopulation(short populationID);		
		
        // Linked list related functions
        /*
        void AddEnemyToList(LevelResidentPtr enemyToAdd);
        void AddItemToList(LevelResidentPtr itemToAdd);
        void RemoveEnemyFromList(GameEnemyPtr enemyToRemove);
        void RemoveItemFromList(GameItemPtr itemToRemove);
        void DeleteEnemyList();
        void DeleteItemList();
        */
        
        // Utility functions
        Boolean IsResidentAnEnemy(LevelResidentPtr residentToTest);
};

typedef GameLevel* GameLevelPtr;
typedef GameLevel** GameLevelHandle;

// non-member functions	
Boolean SeriousError(OSErr errorCode);

// constants
const short kEmpty = -1;

const short kCurrentLevelVersion = 2;
const short kLevelResourceID = 201;
const OSType kLevelFileType = 'Levl';
const ResType kLevelResourceType = 'Lmap';
const Str255 kLevelName = "\pLevel data to save";

const ResType kLevelPopulationResourceType = 'Lpop';
const short kLevelPopulationResourceID = 201;
const Str255 kLevelPopulationName = "\pLevel Population";
const short kCurrentLevelPopulationVersion = 1;


