// GameLevel.cp  Book version.		Written by Mark Szymczyk

#ifndef GAME_LEVEL
	#include "GameLevel.h"
#endif

// Level Resident Accessor functions
PopulationItem LevelResident::GetResident(void) 				
{ 
    return resident; 
}

void LevelResident::SetResident(PopulationItem theResident)	
{ 
    resident = theResident; 
}
		
short LevelResident::GetStartX(void) 	
{ 
    return startX; 
}

void LevelResident::SetStartX(short x) 	
{ 
    startX = x; 
}
		
short LevelResident::GetStartY(void) 	
{ 
    return startY; 
}
void LevelResident::SetStartY(short y)	
{ 
    startY = y; 
}

// LevelResident constructor
LevelResident::LevelResident(void)
{
	SetResident(kNoItem);
	SetStartX(0);
	SetStartY(0);
}

// LevelResident destructor
LevelResident::~LevelResident(void)
{

}


// Map Element Accessor Functions
short MapElement::GetValue(void)
{
	return value;
}

void MapElement::SetValue(short theValue)
{
	value = theValue;
}

Boolean MapElement::IsVisibleToPlayer(void)
{
	return visibleToPlayer;
}

void MapElement::SetVisibleToPlayer(Boolean visibility)
{
	visibleToPlayer = visibility;
}


// GameLevel default constructor
GameLevel::GameLevel(void)
{
	levelWidth = 0;
	levelHeight = 0;
}

// Copy constructor
GameLevel::GameLevel(const GameLevel& theLevel)
{	
	levelWidth = theLevel.levelWidth;
	levelHeight = theLevel.levelHeight;
	tileID = theLevel.tileID;
	
	AllocateLevelMap();
	UInt32 mapIndex;
	for (short row = 0; row < levelHeight; row++) {
		for (short column = 0; column < levelWidth; column++) {
			mapIndex = (row * levelWidth) + column;
			levelMap[mapIndex].SetValue(theLevel.levelMap[mapIndex].GetValue()) ;
		}
	}

}
	
// Destructor
GameLevel::~GameLevel(void)
{
	DeleteLevelMap();
}

// Overload assignment operator
GameLevel& GameLevel::operator= (const GameLevel& theLevel)
{
	if (this != &theLevel) { 		// Avoid self assignment
		DeleteLevelMap();
		levelWidth = theLevel.levelWidth;
		levelHeight = theLevel.levelHeight;
		tileID = theLevel.tileID;
	
		AllocateLevelMap();
		UInt32 mapIndex;
		for (short row = 0; row < levelHeight; row++) {
			for (short column = 0; column < levelWidth; column++) {
				mapIndex = (row * levelWidth) + column;
				levelMap[mapIndex].SetValue(theLevel.levelMap[mapIndex].GetValue());
				//levelMap[row][column].SetValue(theLevel.levelMap[row][column].GetValue());
			}
		}
	}
	
	return *this;
}

// Accessor Functions
short GameLevel::GetLevelWidth(void) 
{ 
	return levelWidth;
}

void GameLevel::SetLevelWidth(short width) 
{ 
	levelWidth = width; 
}

short GameLevel::GetLevelHeight(void) 
{ 
	return levelHeight; 
}
		
void GameLevel::SetLevelHeight(short height) 
{ 
	levelHeight = height; 
}
		
short GameLevel::GetTileID(void) 
{ 
	return tileID; 
}
		
void GameLevel::SetTileID(short theID) 
{ 
	tileID = theID; 
}

/*
LinkedList GameLevel::GetEnemyList(void)
{
    return enemyList;
}

void GameLevel::SetEnemyList(LinkedList theList)
{
    enemyList = theList;
}

LinkedList GameLevel::GetItemList(void)
{
    return itemList;
}

void GameLevel::SetItemList(LinkedList theList)
{
    itemList = theList;
}
*/

void GameLevel::AllocateLevelMap(void)
{
	size_t levelMapSize = levelWidth * levelHeight * sizeof(MapElement);
	levelMap = (MapElementPtr)NewPtr(levelMapSize);
}

void GameLevel::DeleteLevelMap(void)
{
	if (levelMap != nil) {
		DisposePtr((Ptr)levelMap);
		levelMap = nil;
	}
}

void GameLevel::InitializeLevelMap (short value)
{
	UInt32 mapIndex;
	
	for (short row = 0; row < levelHeight; row++) {
		for (short column = 0; column < levelWidth; column++) {
			mapIndex = (row * levelWidth) + column;
			levelMap[mapIndex].SetValue(value);
			levelMap[mapIndex].SetVisibleToPlayer(true);
		}
	}
}

// file related functions
Boolean GameLevel::ReadLevelData(short levelID)
{
	short error;
	//short refNum;
	Handle savedLevel;
	
	savedLevel = GetResource(kLevelResourceType, levelID);
	//savedLevel = (LevelHandle) Get1Resource(kLevelResourceType, kBackgroundResourceID);
	error = ResError();
	if ((error != noErr) || (savedLevel == nil))
		return false;
		
	// Now let's set the level data
	short version;
	short theLevelWidth;
	short theLevelHeight;
	short theTileID;
	Size offset = 0;

	BlockMoveData(*savedLevel + offset, &version, sizeof(short));
	offset = offset + sizeof(short);
	
	// If resource is obsolete, don't load it.
	if (version != kCurrentLevelVersion) {
		ReleaseResource(Handle(savedLevel));
		//CloseResFile(refNum);
		return false;
	}
	
	BlockMoveData(*savedLevel + offset, &theLevelWidth, sizeof(short));
	offset = offset + sizeof(short);
	BlockMoveData(*savedLevel + offset, &theLevelHeight, sizeof(short));
	offset = offset + sizeof(short);
	BlockMoveData(*savedLevel + offset, &theTileID, sizeof(short));
	offset = offset + sizeof(short);
	
	SetLevelWidth(theLevelWidth);
	SetLevelHeight(theLevelHeight);
	SetTileID(theTileID);
	
	// Now that we have the level width and level height, allocate
	// the level map.
	AllocateLevelMap();
	
	UInt32 mapIndex;
	for(short row = 0; row < theLevelHeight; row++) {
		for(short column = 0; column < theLevelWidth; column++) {
			mapIndex = (row * theLevelWidth) + column;
			BlockMoveData(*savedLevel + offset, &(levelMap[mapIndex]), sizeof(MapElement));
			
			//Temporary
			//levelMap[mapIndex].SetVisibleToPlayer(true);
			
			offset = offset + sizeof(MapElement);
		}
	}

	// Clean up
	ReleaseResource(Handle(savedLevel));
	error = ResError();
	if (SeriousError(error))
		return false;
	
	return true;
	
}

/*
Boolean GameLevel::ReadLevelPopulation(short populationID)
{
	short error;
	short refNum;
	Handle savedPopulation;
	
	// Clear out anything that's remaining in the monster and item lists
	DeleteMonsterList();
    DeleteItemList();
	
	savedPopulation = Get1Resource(kLevelPopulationResourceType, populationID);
	error = ResError();
	if ((error != noErr) || (savedPopulation == nil))
		return false;
		
	// Now let's set the level data
	short version;
	short startX;
	short startY;
	short populationCount;
	Size offset = 0;
	
	BlockMoveData(*savedPopulation + offset, &version, sizeof(short));
	offset = offset + sizeof(short);
	
	// If resource is obsolete, don't load it.
	if (version != kCurrentLevelPopulationVersion) {
		ReleaseResource(Handle(savedPopulation));
		CloseResFile(refNum);
		return false;
	}
	
	// At the start of the level population resource is the
    // player's starting position in the level.  We read this
    // data, but don't do anything with it.
    BlockMoveData(*savedPopulation + offset, &startX, sizeof(short));
	offset = offset + sizeof(short);
	BlockMoveData(*savedPopulation + offset, &startY, sizeof(short));
	offset = offset + sizeof(short);
    
	// Read the number of enemies and items in the level
    BlockMoveData(*savedPopulation + offset, &populationCount, sizeof(short));
	offset = offset + sizeof(short);
	
	LevelResident currentResident;
	
	// Read the enemies and items from disk
    for (short i = 0; i < populationCount; i++) {
		BlockMoveData(*savedPopulation + offset, &currentResident, sizeof(LevelResident));

		if (IsResidentAnEnemy(&currentResident)) {
			AddEnemyToList(&currentResident);
		}
		else {
			AddItemToList(&currentResident);
		}

		offset = offset + sizeof(LevelResident);
	}
	
	// Clean up
	ReleaseResource(Handle(savedPopulation));
	error = ResError();
	if (SeriousError(error))
		return false;

	return true;
	
}
*/

// Linked list related functions
/*
void GameLevel::AddEnemyToList(LevelResidentPtr enemyToAdd)
{
    
	SpriteBuffer monsterToAddStorage;
	
	switch (enemyToAdd->GetResident()) {
		case kEnemy:
			GameEnemyPtr newEnemy = new Enemy;
			if (newEnemy != nil) {
				newEnemy->SetWorldX(enemyToAdd->GetStartX());
				newEnemy->SetWorldY(enemyToAdd->GetStartY());
				newEnemy->DetermineViewRect(currentLevel, theTileList);
			
				monsterToAddStorage = theDrawContext->GetEnemySpriteStorage();
				newEnemy->SetSpriteStorage(monsterToAddStorage);
				newEnemy->SetSpriteWidth(kEnemySpriteWidth);
				newEnemy->SetSpriteHeight(kEnemySpriteHeight);
				newEnemy->SetDestination(theDrawContext);
				newEnemy->InitializeSpriteBlitter();
				
				newEnemy->SetMonsterWeapon(&(weaponList[kEnemyBiteIndex]));
				enemyList.AddItem(newEnemy);
			}
			break;
        }
        
}

void GameLevel::AddItemToList(LevelResident itemToAdd)
{
	
    GameItemPtr newItem = new GameItem;
	SpriteBuffer itemToAddStorage;
	
	newItem->SetWorldX(itemToAdd->GetStartX());
	newItem->SetWorldY(itemToAddGetStartY());
	
	switch (itemToAdd->GetResident()) {
		case kCrossbow:
			itemToAddStorage = theDrawContext->GetItemSpriteStorage();
			newItem->SetWhatItIs(kCrossbow);
			newItem->SetSpriteStorage(itemToAddStorage);
			newItem->SetSpriteWidth(kCrossbowSpriteWidth);
			newItem->SetSpriteHeight(kCrossbowSpriteHeight);
			newItem->SetSpriteRow(kCrossbowSpriteRow);
			newItem->SetSpriteColumn(kCrossbowSpriteColumn);
			newItem->SetDestination(theDrawContext);
			newItem->InitializeSpriteBlitter();
			break;

		case kBolts:
			itemToAddStorage = theDrawContext->GetItemSpriteStorage();
			newItem->SetWhatItIs(kBolts);
			newItem->SetSpriteStorage(itemToAddStorage);
			newItem->SetSpriteWidth(kBoltsSpriteWidth);
			newItem->SetSpriteHeight(kBoltsSpriteHeight);
			newItem->SetSpriteRow(kBoltsSpriteRow);
			newItem->SetSpriteColumn(kBoltsSpriteColumn);
			newItem->SetDestination(theDrawContext);
			newItem->InitializeSpriteBlitter();
			break;


		case kCoins:
			itemToAddStorage = theDrawContext->GetItemSpriteStorage();
			newItem->SetWhatItIs(kCoins);
			newItem->SetSpriteStorage(itemToAddStorage);
			newItem->SetSpriteWidth(kCoinsSpriteWidth);
			newItem->SetSpriteHeight(kCoinsSpriteHeight);
			newItem->SetSpriteRow(kCoinsSpriteRow);
			newItem->SetSpriteColumn(kCoinsSpriteColumn);
			newItem->SetDestination(theDrawContext);
			newItem->InitializeSpriteBlitter();
			break;

		case kGems:
			itemToAddStorage = theDrawContext->GetItemSpriteStorage();
			newItem->SetWhatItIs(kGems);
			newItem->SetSpriteStorage(itemToAddStorage);
			newItem->SetSpriteWidth(kGemsSpriteWidth);
			newItem->SetSpriteHeight(kGemsSpriteHeight);
			newItem->SetSpriteRow(kGemsSpriteRow);
			newItem->SetSpriteColumn(kGemsSpriteColumn);
			newItem->SetDestination(theDrawContext);
			newItem->InitializeSpriteBlitter();
			break;

		case kHealingPotion:
			itemToAddStorage = theDrawContext->GetItemSpriteStorage();
			newItem->SetWhatItIs(kHealingPotion);
			newItem->SetSpriteStorage(itemToAddStorage);
			newItem->SetSpriteWidth(kHealingPotionSpriteWidth);
			newItem->SetSpriteHeight(kHealingPotionSpriteHeight);
			newItem->SetSpriteRow(kHealingPotionSpriteRow);
			newItem->SetSpriteColumn(kHealingPotionSpriteColumn);
			newItem->SetDestination(theDrawContext);
			newItem->InitializeSpriteBlitter();
			break;

		default:
		 	break;
	}
	
	// Add item to item list
	itemList.AddItem(newItem);
    
}

void GameLevel::RemoveEnemyFromList(GameEnemyPtr enemyToRemove)
{
    
}

void GameLevel::RemoveItemFromList(GameEnemyPtr itemToRemove)
{
        
}

void GameLevel::DeleteEnemyList(void)
{
    Iterator enemyListIterator(&enemyList);
    GameEnemyPtr currentEnemy;

    int itemsToDispose = enemyList.GetNumberOfItems();
    
    while(itemsToDispose > 0) {        
        currentEnemy = (GameEnemyPtr)enemyListIterator.Next();
        enemyList.RemoveItem(currentEnemy);
        itemsToDispose--;
    }
}

void GameLevel::DeleteItemList(void)
{
    Iterator itemListIterator(&itemList);
    GameItemPtr currentItem;

    int itemsToDispose = itemList.GetNumberOfItems();
    
    while(itemsToDispose > 0) {        
        currentItem = (GameItemPtr)itemListIterator.Next();
        itemList.RemoveItem(currentItem);
        itemsToDispose--;
    }

}
*/

// Utility functions
Boolean GameLevel::IsResidentAnEnemy(LevelResidentPtr residentToTest)
{
	switch (residentToTest->GetResident()) {
		case kEnemy:
        // You would add cases for your all game's enemies here
			return true;
			break;
			
		default:
			return false;
			break;
	}
}

// Non-member functions
Boolean SeriousError(OSErr errorCode)
{
	switch (errorCode) {
		case noErr:
		case dupFNErr:
		case opWrErr:
			 	return false;
		default:
				return true;
				
	}
}
