// GameItem.h		by Mark Szymczyk

#ifndef GAME_SPRITE
	#include "GameSprite.h"
#endif

#ifndef GAME_LEVEL
	#include "GameLevel.h"
#endif

#define GAME_ITEM

class GameItem : public GameSprite
{
	protected:
		PopulationItem whatItIs;
		Boolean killed;
        
	public:
		// Constructor and destructor
		GameItem(void);
        virtual ~GameItem(void);
		
		// Accessors
		PopulationItem GetWhatItIs(void); 			
		void SetWhatItIs(PopulationItem theItem);	
		
		Boolean WasKilled(void);				
		void SetKilled(Boolean killValue);	
		void Kill(void);	
		
		void DetermineSpriteToDraw(void);
};

typedef GameItem* GameItemPtr;
typedef GameItem** GameItemHandle;

// Constants
const short kItemSpriteWidth = 32;
const short kItemSpriteHeight = 32;

const short kBoltsSpriteRow = 0;
const short kBoltsSpriteColumn = 0;
const short kHealingPotionSpriteRow = 0;
const short kHealingPotionSpriteColumn = 1;
const short kCoinsSpriteRow = 0;
const short kCoinsSpriteColumn = 2;
const short kGemsSpriteRow = 0;
const short kGemsSpriteColumn = 3;