// GameEnemy.h 		By Mark Szymczyk

#ifndef GAME_SPRITE
	#include "GameSprite.h"
#endif

#ifndef GAME_WEAPON
	#include "GameWeapon.h"
#endif

#ifndef FINITE_STATE
    #include "FiniteState.h"
#endif

#ifndef INPUT_CONTROLLER
	#include "InputController.h"
#endif

#define GAME_ENEMY

class GameEnemy : public GameSprite
{
	protected:
		StateType mood;
		Rect viewRect;
		short goalX;		// Where to go when monster is stuck
		short goalY;
		GameWeaponPtr enemyWeapon;
		short hitPoints;
		short pointValue;	// Points player receives for killing it;
		//Boolean killed;

	public:
		// Constructor and destructor
        GameEnemy(void);
        virtual ~GameEnemy(void);
		
		// Accessors
		StateType GetMood(void); 				
        void SetMood(StateType theMood);	
		
		Rect GetViewRect(void); 			
		void SetViewRect(Rect theRect);	
		
		short GetGoalX(void); 	
		void SetGoalX(short x);	

		short GetGoalY(void); 	
		void SetGoalY(short y);	

		GameWeaponPtr GetEnemyWeapon(void);				
		void SetEnemyWeapon(GameWeaponPtr theWeapon);	
		
		short GetHitPoints(void); 	
		void SetHitPoints(short hp);	

		short GetPointValue(void); 			
		void SetPointValue(short theValue);	
		
		//Boolean WasKilled(void);			{ return killed; }
		//void SetKilled(Boolean killValue)	{ killed = killValue; }
		//void Kill(void)	{ SetKilled(true); }

		//virtual void CalculateXSpeed(Boolean diagonalMovement);
		//virtual void CalculateYSpeed(Boolean diagonalMovement);
		short GetFramesInSequence(void);   	// Descended from Sprite
		void DetermineSpriteToDraw(void);
				
		// View Rectangle functions
		void DetermineViewRect(GameLevelPtr theLevel, GameTileListPtr theTiles);
		virtual short ComputeUpViewRect(GameLevelPtr theLevel, GameTileListPtr theTiles);
		virtual short ComputeDownViewRect(GameLevelPtr theLevel, GameTileListPtr theTiles);
		virtual short ComputeLeftViewRect(GameLevelPtr theLevel, GameTileListPtr theTiles);
		virtual short ComputeRightViewRect(GameLevelPtr theLevel, GameTileListPtr theTiles);
		//Boolean IsPlayerInViewRect(short playerX, short playerY);
		//Boolean IsInViewRect(short x, short y);
		
		// Miscellaneous functions
		Vector2D CalculateForce(InputControllerAction movement);
        //Vector2D CalculateForce(void);
		void TakeHit(GameWeaponPtr weaponThatHit);
		Boolean WasKilled(void);
};

typedef GameEnemy* GameEnemyPtr;
typedef GameEnemy** GameEnemyHandle;

// constants
const short kEnemySpriteWidth = 48;
const short kEnemySpriteHeight = 48;

const short kEnemyMoveFrames = 7;
const short kEnemyFightFrames = 4;
const short kEnemyUpFrame = 0;
const short kEnemyDownFrame = 1;
const short kEnemyLeftFrame = 2;
const short kEnemyRightFrame = 3;
const short kEnemyStandFrame = 0;
const short kEnemyMoveFrame = 1;
const short kEnemyAttackFrame = 8;

const short kNoOpeningFound = -1;
const long kMaximumDistance = 999999999;

const double kEnemyMass = 200.0;
const double kEnemyForce = 10000.0;
const double kEnemyMaxSpeed = 100.0;
const short kEnemyHitPoints = 10;
const short kEnemyPointValue = 100;