// GameEnemy.cp		by Mark Szymczyk

#ifndef GAME_ENEMY
	#include "GameEnemy.h"
#endif

// Constructor
GameEnemy::GameEnemy(void)
{
	SetMood(kPatrollingState);
	SetViewRect(kEmptyRect);
	//SetKilled(false);
	SetGoalX(0);
	SetGoalY(0);
    enemyWeapon = nil;
    SetHitPoints(0);
    SetPointValue(0);
    //SetSpriteWidth(kEnemySpriteWidth);
    //SetSpriteHeight(kEnemySpriteHeight);
}

// Destructor
GameEnemy::~GameEnemy(void)
{

}

// Accessors
StateType GameEnemy::GetMood(void) 		
{ 
    return mood; 
}

void GameEnemy::SetMood(StateType theMood)	
{ 
    mood = theMood; 
}
		
Rect GameEnemy::GetViewRect(void) 			
{ 
    return viewRect; 
}
		
void GameEnemy::SetViewRect(Rect theRect)	
{ 
    viewRect = theRect; 
}
		
short GameEnemy::GetGoalX(void) 	
{ 
    return goalX; 
}

void GameEnemy::SetGoalX(short x)	
{ 
    goalX = x; 
}

short GameEnemy::GetGoalY(void) 	
{ 
    return goalY; 
}

void GameEnemy::SetGoalY(short y)	
{ 
    goalY = y; 
}

GameWeaponPtr GameEnemy::GetEnemyWeapon(void) 				
{ 
    return enemyWeapon; 
}
		
void GameEnemy::SetEnemyWeapon(GameWeaponPtr theWeapon)	
{ 
    enemyWeapon = theWeapon; 
}
		
short GameEnemy::GetHitPoints(void) 	
{ 
    return hitPoints; 
}

void GameEnemy::SetHitPoints(short hp)	
{ 
    hitPoints = hp; 
}

short GameEnemy::GetPointValue(void) 			
{ 
    return pointValue; 
}

void GameEnemy::SetPointValue(short theValue)	
{ 
    pointValue = theValue; 
}


short GameEnemy::GetFramesInSequence(void)
{
	int monsterAction = GetAction();
	
	switch (monsterAction) {
		case kSpriteMoving:
			return kEnemyMoveFrames;
			break;
			
		case kSpriteFighting:
			return kEnemyFightFrames;
			break;
			
		default:
			return 0;
	}
}

void GameEnemy::DetermineSpriteToDraw(void)
{
	// Calculate sprite row
	short currentRow;
	
	switch (direction) {
		case kSpriteFacingUp:
			currentRow = kEnemyUpFrame;
			break;
			
		case kSpriteFacingDown:
			currentRow = kEnemyDownFrame;
			break;
			
		case kSpriteFacingLeft:
			currentRow = kEnemyLeftFrame;
			break;
			
		case kSpriteFacingRight:
			currentRow = kEnemyRightFrame;
			break;
			
		default:
			break;
		
	}

	SetSpriteRow(currentRow);
	
	// Now calculate sprite column
	short currentColumn;
	
	switch (action) {
		case kSpriteStanding:
			currentColumn = kEnemyStandFrame;
			break;
			
		case kSpriteMoving:	
			currentColumn = kEnemyMoveFrame + frame;
			break;
			
		case kSpriteFighting:
			currentColumn = kEnemyAttackFrame + frame;
			break;
			
		default:
			break;
			
	}

	SetSpriteColumn(currentColumn);
}



// View Rectangle functions
void GameEnemy::DetermineViewRect(GameLevelPtr theLevel, GameTileListPtr theTiles)
{
	if (theLevel == nil)
		return;
		
	if (theTiles == nil)
		return;
		
	Rect newViewRect;
	
	newViewRect.top = ComputeUpViewRect(theLevel, theTiles);
	newViewRect.bottom = ComputeDownViewRect(theLevel, theTiles);
	newViewRect.left = ComputeLeftViewRect(theLevel, theTiles);
	newViewRect.right = ComputeRightViewRect(theLevel, theTiles);
	
	SetViewRect(newViewRect);
}
		
short GameEnemy::ComputeUpViewRect(GameLevelPtr theLevel, GameTileListPtr theTiles)
{
	if (theLevel == nil)
		return 0;
		
	if (theTiles == nil)
		return 0;

	short tileNum;
	GameTileType tileAttribute;
	short theLevelWidth = theLevel->GetLevelWidth();
	UInt32 mapIndex;
	
	short rowToTest = (worldY - 1) / kTileHeight;
	short columnToTest = worldX / kTileWidth;
	mapIndex = (rowToTest * theLevelWidth) + columnToTest;
	tileNum = theLevel->levelMap[mapIndex].GetValue();	
	tileAttribute = theTiles->tileTable[tileNum].GetTileType();
	
	// We start at the tile one pixel above us.  We move up one tile at a
	// time until we hit a wall or door tile.
	while ((tileAttribute != kWallTile) && (tileAttribute != kDoorTile)) {
		rowToTest--;
		mapIndex = (rowToTest * theLevelWidth) + columnToTest;
		tileNum = theLevel->levelMap[mapIndex].GetValue();	
		tileAttribute = theTiles->tileTable[tileNum].GetTileType();
	}
		
	return (rowToTest * kTileHeight);

}
		
short GameEnemy::ComputeDownViewRect(GameLevelPtr theLevel, GameTileListPtr theTiles)
{
	if (theLevel == nil)
		return 0;
		
	if (theTiles == nil)
		return 0;

	short tileNum;
	GameTileType tileAttribute;
	short theLevelWidth = theLevel->GetLevelWidth();
	UInt32 mapIndex;
	
	short rowToTest = (worldY + spriteHeight + 1) / kTileHeight;
	short columnToTest = worldX / kTileWidth;
	mapIndex = (rowToTest * theLevelWidth) + columnToTest;
	tileNum = theLevel->levelMap[mapIndex].GetValue();	
	tileAttribute = theTiles->tileTable[tileNum].GetTileType();
	
	// We start at the tile one pixel below us.  We move down one tile at a
	// time until we hit a wall or door tile.
	while ((tileAttribute != kWallTile) && (tileAttribute != kDoorTile)) {
		rowToTest++;
		mapIndex = (rowToTest * theLevelWidth) + columnToTest;
		tileNum = theLevel->levelMap[mapIndex].GetValue();	
		tileAttribute = theTiles->tileTable[tileNum].GetTileType();
	}
		
	return (rowToTest * kTileHeight);

}
	
short GameEnemy::ComputeLeftViewRect(GameLevelPtr theLevel, GameTileListPtr theTiles)
{
	if (theLevel == nil)
		return 0;
		
	if (theTiles == nil)
		return 0;

	short tileNum;
	GameTileType tileAttribute;
	short theLevelWidth = theLevel->GetLevelWidth();
	UInt32 mapIndex;
	
	short rowToTest = worldY / kTileHeight;
	short columnToTest = (worldX - 1) / kTileWidth;
	mapIndex = (rowToTest * theLevelWidth) + columnToTest;
	tileNum = theLevel->levelMap[mapIndex].GetValue();	
	tileAttribute = theTiles->tileTable[tileNum].GetTileType();
	
	// We start at the tile one pixel to the left of us.  We move left one tile at a
	// time until we hit a wall or door tile.
	while ((tileAttribute != kWallTile) && (tileAttribute != kDoorTile)) {
		columnToTest--;
		mapIndex = (rowToTest * theLevelWidth) + columnToTest;
		tileNum = theLevel->levelMap[mapIndex].GetValue();	
		tileAttribute = theTiles->tileTable[tileNum].GetTileType();
	}
		
	return (columnToTest * kTileHeight);

}
		
short GameEnemy::ComputeRightViewRect(GameLevelPtr theLevel, GameTileListPtr theTiles)
{
	if (theLevel == nil)
		return 0;
		
	if (theTiles == nil)
		return 0;

	short tileNum;
	GameTileType tileAttribute;
	short theLevelWidth = theLevel->GetLevelWidth();
	UInt32 mapIndex;
	
	short rowToTest = worldY / kTileHeight;
	short columnToTest = (worldX + spriteWidth + 1)/ kTileWidth;
	mapIndex = (rowToTest * theLevelWidth) + columnToTest;
	tileNum = theLevel->levelMap[mapIndex].GetValue();	
	tileAttribute = theTiles->tileTable[tileNum].GetTileType();
	
	// We start at the tile one pixel to the right of us.  We move right one tile at a
	// time until we hit a wall or door tile.
	while ((tileAttribute != kWallTile) && (tileAttribute != kDoorTile)) {
		columnToTest++;
		mapIndex = (rowToTest * theLevelWidth) + columnToTest;
		tileNum = theLevel->levelMap[mapIndex].GetValue();	
		tileAttribute = theTiles->tileTable[tileNum].GetTileType();
	}
		
	return (columnToTest * kTileHeight);

}

// Miscellaneous functions
Vector2D GameEnemy::CalculateForce(InputControllerAction movement)
{
    double xComponent;
    double yComponent;
    
    Vector2D result;
    //SpriteDirection enemyDirection = GetSpriteDirection();
    
    switch (movement) {
		case kMoveUp:		
            xComponent = kStandingSpeed;
			yComponent = kEnemyForce * -1.0;
            break;
			
		case kMoveDown:
            xComponent = kStandingSpeed;			
			yComponent = kEnemyForce;
            break;

		case kMoveLeft:
			xComponent = kEnemyForce * -1.0;
            yComponent = kStandingSpeed;
			break;

		case kMoveRight:
			xComponent = kEnemyForce;
            yComponent = kStandingSpeed;			
			break;

		// For diagonal movement, multiply each component by
		// radical two over two to keep the movement realistic.
		// Multiplying each component by radical two over two
		// provides the same amount of force for diagonal movement
		// as moving in only one direction.  Mathematically, it 
		// involves the use of the Pythagorean Theorem:
		//
		// (a ^ 2) + (b ^ 2) = (c ^ 2)
		case kMoveUpAndLeft:		
            xComponent = kEnemyForce * -1.0 * kRadicalTwoOverTwo;
			yComponent = kEnemyForce * -1.0 * kRadicalTwoOverTwo;
            break;
			
		case kMoveUpAndRight:
            xComponent = kEnemyForce * kRadicalTwoOverTwo;			
			yComponent = kEnemyForce * -1.0 * kRadicalTwoOverTwo;
            break;

		case kMoveDownAndRight:
			xComponent = kEnemyForce * kRadicalTwoOverTwo;
            yComponent = kEnemyForce * kRadicalTwoOverTwo;
			break;

		case kMoveDownAndLeft:
			xComponent = kEnemyForce * -1.0 * kRadicalTwoOverTwo;
            yComponent = kEnemyForce * kRadicalTwoOverTwo;			
			break;
			
		default:
			xComponent = kStandingSpeed;
            yComponent = kStandingSpeed;
			break;
	}
    
    result.SetXComponent(xComponent);
    result.SetYComponent(yComponent);
    
    return result;
}

/*
Vector2D GameEnemy::CalculateForce(void)
{
    double xComponent;
    double yComponent;
    
    Vector2D result;
    SpriteDirection enemyDirection = GetSpriteDirection();
    
    switch (enemyDirection) {
		case kSpriteFacingUp:		
            xComponent = kStandingSpeed;
			yComponent = kEnemyForce * -1.0;
            break;
			
		case kSpriteFacingDown:
            xComponent = kStandingSpeed;			
			yComponent = kEnemyForce;
            break;

		case kSpriteFacingLeft:
			xComponent = kEnemyForce * -1.0;
            yComponent = kStandingSpeed;
			break;

		case kSpriteFacingRight:
			xComponent = kEnemyForce;
            yComponent = kStandingSpeed;			
			break;

		// For diagonal movement, multiply each component by
		// radical two over two to keep the movement realistic.
		// Multiplying each component by radical two over two
		// provides the same amount of force for diagonal movement
		// as moving in only one direction.  Mathematically, it 
		// involves the use of the Pythagorean Theorem:
		//
		// (a ^ 2) + (b ^ 2) = (c ^ 2)
		case kMoveUpAndLeft:		
            xComponent = kEnemyForce * -1.0 * kRadicalTwoOverTwo;
			yComponent = kEnemyForce * -1.0 * kRadicalTwoOverTwo;
            break;
			
		case kMoveUpAndRight:
            xComponent = kEnemyForce * kRadicalTwoOverTwo;			
			yComponent = kEnemyForce * -1.0 * kRadicalTwoOverTwo;
            break;

		case kMoveDownAndRight:
			xComponent = kEnemyForce * kRadicalTwoOverTwo;
            yComponent = kEnemyForce * kRadicalTwoOverTwo;
			break;

		case kMoveDownAndLeft:
			xComponent = kEnemyForce * -1.0 * kRadicalTwoOverTwo;
            yComponent = kEnemyForce * kRadicalTwoOverTwo;			
			break;
			
		default:
			xComponent = kStandingSpeed;
            yComponent = kStandingSpeed;
			break;
	}
    
    result.SetXComponent(xComponent);
    result.SetYComponent(yComponent);
    
    return result;
}
*/

void GameEnemy::TakeHit(GameWeaponPtr weaponThatHit)
{
	if (weaponThatHit == nil)
		return;

	hitPoints = hitPoints - weaponThatHit->GetDamage();
}

Boolean GameEnemy::WasKilled(void)
{
	if (hitPoints <= 0)
		return true;
	else
		return false;
}
