// GameContext.h  		Written by Mark Szymczyk
// Book Version

// The GameContext class looks different in the game itself.
// In the game, we use DrawSprocket and create a DrawContext class
// to go into fullscreen mode.  The GameContext class in the game
// inherits from this DrawContext class.  We haven't covered 
// DrawSprocket yet so the GameContext class doesn't inherit
// from any other classes here.

#ifndef __CARBON__
    #include <Carbon/Carbon.h>
#endif

#ifndef BLITTER
	#include "Blitter.h"
#endif

#ifndef GAME_OFFSCREEN_BUFFER
	#include "GameOffscreenBuffer.h"
#endif

#ifndef GAME_TILE
	#include "GameTile.h"
#endif

#ifndef GAME_LEVEL
	#include "GameLevel.h"
#endif


#define GAME_CONTEXT

class GameContext 
{
	protected:
		GameOffscreenBufferPtr background;
		GameOffscreenBufferPtr tileStorage;
        GameOffscreenBufferPtr playerSpriteStorage;
        GameOffscreenBufferPtr enemySpriteStorage;
        GameOffscreenBufferPtr weaponSpriteStorage;
        GameOffscreenBufferPtr itemSpriteStorage;
        char* dirtyRectTable;
		
		short screenWidth;
		short screenHeight;
	
		short hOffset;		// In tiles
		short vOffset;		// In tiles
		Blitter tileBlitter;

		
	public:
		GameContext(void);
		virtual ~GameContext(void);
		void CleanUp(void);
		
		// Accessors
		GameOffscreenBufferPtr GetBackground(void);
		void SetBackground(GameOffscreenBufferPtr theBackground);
		
		GameOffscreenBufferPtr GetTileStorage(void);
		void SetTileStorage (GameOffscreenBufferPtr theStorage);

		GameOffscreenBufferPtr GetPlayerSpriteStorage(void);
		void SetPlayerSpriteStorage(GameOffscreenBufferPtr theStorage);

		GameOffscreenBufferPtr GetEnemySpriteStorage(void);
		void SetEnemySpriteStorage(GameOffscreenBufferPtr theStorage);

		GameOffscreenBufferPtr GetWeaponSpriteStorage(void);
		void SetWeaponSpriteStorage(GameOffscreenBufferPtr theStorage);

		GameOffscreenBufferPtr GetItemSpriteStorage(void);
		void SetItemSpriteStorage(GameOffscreenBufferPtr theStorage);
        
        char* GetDirtyRectTable(void);
        void SetDirtyRectTable(char* theTable);
		
		short GetScreenWidth(void);
		void SetScreenWidth(short theWidth);

		short GetScreenHeight(void);
		void SetScreenHeight(short theHeight);

		short GetHOffset(void);
		void SetHOffset(short theOffset);

		short GetVOffset(void);
		void SetVOffset(short theOffset);
		
		Blitter GetTileBlitter(void);
		void SetTileBlitter(Blitter theBlitter);
		
		

		// Drawing and back buffer related functions
		Boolean CreateBackground(short width, short height, short colorDepth,
									CTabHandle colorTable, GWorldFlags flags);
		Boolean CreateTileStorage(short width, short height, short colorDepth,
									CTabHandle colorTable, GWorldFlags flags);
        Boolean CreateSpriteBuffers(short colorDepth,
                        CTabHandle colorTable, GWorldFlags flags);
									
		
		void DisposeBackground(void);
		void DisposeTileStorage(void);
        void DisposeSpriteBuffers(void);
		
		void DrawBackground(GameLevelPtr theLevel);
		void DrawTileStorage(short pictureID);
        void DrawSpriteBuffers(void);

		void UpdateBackground(RectPtr updateRect, GameLevelPtr theLevel);
		void DrawTileFromLevelMap(GameLevelPtr theLevel, short theRow, short theColumn);
		
		void InitializeTileBlitter(void);

		
		// Scrolling functions
		short ScrollLeft(GameLevelPtr theLevel, short tilesToScroll);
		short ScrollRight(GameLevelPtr theLevel, short tilesToScroll);
		short ScrollUp(GameLevelPtr theLevel, short tilesToScroll);
		short ScrollDown(GameLevelPtr theLevel, short tilesToScroll);

        // Dirty rectangle functions
        void AllocateDirtyRectTable(void);
        void CleanDirtyRectTable(void);
        void MarkRectangleDirty(short row, short column);
        Boolean IsRectangleDirty(short row, short column);
        void DisposeDirtyRectTable(void);
        Rect GetDirtyRect(short row, short column);

		// Utility functions
		Point GetGridLocation(short tileNumber);
		Rect GetRectFromGridLocation(Point theGridLocation);

};

typedef GameContext* GameContextPtr;
typedef GameContext** GameContextHandle;

// Constants to make sure we don't scroll past the level map
const short kLeftEdge = 0;
const short kTopEdge = 0;


// Other Constants
const short kPlayerSpriteID = 300;
const short kEnemySpriteID = 301;
const short kWeaponSpriteID = 302;
const short kItemSpriteID = 303;

const short kTileWidth = 32;
const short kTileHeight = 32;

const char kRectangleIsClean = 0;
const char kRectangleIsDirty = 1;

