// GameCollision.cp		by Mark Szymczyk
// Book version

#ifndef GAME_SPRITE
	#include "GameSprite.h"
#endif

#ifndef VECTOR_2D
	#include "Vector2D.h"
#endif

#define GAME_COLLISION

// This class stores all the data involved with a collision.
// It's easier to pass a GameCollision object to the PhysicsController
// class than a bunch of variables that are needed to resolve the collision.

class GameCollision
{
	protected:
		// The two colliding objects.  If you want to
		// handle multiple collisions, you would need
		// an array of GameSprite pointers.
		GameSpritePtr firstObject;
		GameSpritePtr secondObject;
		
		// Point of collision
		double collisionPointX;
		double collisionPointY;
		
		Vector2D collisionNormal;
		
		// These vectors are used for rotating objects
		Vector2D collisionPointToCenterOfMassA;
		Vector2D collisionPointToCenterOfMassB;
		
		// Measures the bounciness of the collision
		// Value between 0 and 1.  Higher value means more bounce.
		double coefficientOfRestitution;
		
	public:
		GameCollision(void);
		virtual ~GameCollision(void);
		
		// Accessors
		GameSpritePtr GetFirstObject(void);
		void SetFirstObject(GameSpritePtr theObject);
		
		GameSpritePtr GetSecondObject(void);
		void SetSecondObject(GameSpritePtr theObject);
		
		double GetCollisionPointX(void);
		void SetCollisionPointX(double xValue);
		
		double GetCollisionPointY(void);
		void SetCollisionPointY(double yValue);

		Vector2D GetCollisionNormal(void);
		void SetCollisionNormal(Vector2D normalVector);
		
		Vector2D GetCollisionPointToCenterOfMassA(void);
		void SetCollisionPointToCenterOfMassA(Vector2D vectorValue);

		Vector2D GetCollisionPointToCenterOfMassB(void);
		void SetCollisionPointToCenterOfMassB(Vector2D vectorValue);
		
		double GetCoefficientOfRestitution(void);
		void SetCoefficientOfRestitution(double coefficient);		
};

typedef GameCollision* GameCollisionPtr;
typedef GameCollision** GameCollisionHandle;
