// GameCollision.cp		by Mark Szymczyk
// Book version

#ifndef GAME_COLLISION
	#include "GameCollision.h"
#endif

// Constructor
GameCollision::GameCollision(void)
{
	firstObject = nil;
	secondObject = nil;
	
	collisionPointX = 0.0;
	collisionPointY = 0.0;
	coefficientOfRestitution = 0.0;
}

// Destructor
GameCollision::~GameCollision(void)
{

}


// Accessors
GameSpritePtr GameCollision::GetFirstObject(void)
{
	return firstObject;
}

void GameCollision::SetFirstObject(GameSpritePtr theObject)
{
	firstObject = theObject;
}

GameSpritePtr GameCollision::GetSecondObject(void)
{
	return secondObject;
}

void GameCollision::SetSecondObject(GameSpritePtr theObject)
{
	secondObject = theObject;
}
		
double GameCollision::GetCollisionPointX(void)
{
	return collisionPointX;
}

void GameCollision::SetCollisionPointX(double xValue)
{
	collisionPointX = xValue;
}

double GameCollision::GetCollisionPointY(void)
{
	return collisionPointY;
}

void GameCollision::SetCollisionPointY(double yValue)
{
	collisionPointY = yValue;
}

Vector2D GameCollision::GetCollisionNormal(void)
{
	return collisionNormal;
}
		
void GameCollision::SetCollisionNormal(Vector2D normalVector)
{
	collisionNormal = normalVector;
}
		
Vector2D GameCollision::GetCollisionPointToCenterOfMassA(void)
{
	return collisionPointToCenterOfMassA;
}

void GameCollision::SetCollisionPointToCenterOfMassA(Vector2D vectorValue)
{
	collisionPointToCenterOfMassA = vectorValue;
}

Vector2D GameCollision::GetCollisionPointToCenterOfMassB(void)
{
	return collisionPointToCenterOfMassB;
}

void GameCollision::SetCollisionPointToCenterOfMassB(Vector2D vectorValue)
{
	collisionPointToCenterOfMassB = vectorValue;
}
		
double GameCollision::GetCoefficientOfRestitution(void)
{
	return coefficientOfRestitution;
}

void GameCollision::SetCoefficientOfRestitution(double coefficient)
{
	coefficientOfRestitution = coefficient;		
}

