// GameApp.h		Written by Mark Szymczyk
// Book Version

#ifndef __CARBON__
    #include <Carbon/Carbon.h>
#endif

// Include QuickTime for Begin/End Full Screen functions
#ifndef __MOVIES__
    #include <QuickTime/Movies.h>
#endif

#ifndef GAME_OFFSCREEN_BUFFER
	#include "GameOffscreenBuffer.h"
#endif

#ifndef BLITTER
	#include "Blitter.h"
#endif

#ifndef GAME_LEVEL
	#include "GameLevel.h"
#endif

#ifndef GAME_TILE
	#include "GameTile.h"
#endif

#ifndef GAME_CONTEXT
	#include "GameContext.h"
#endif

#ifndef INPUT_CONTROLLER
	#include "InputController.h"
#endif

#ifndef ANIMATION_CONTROLLER
	#include "AnimationController.h"
#endif

#ifndef PHYSICS_CONTROLLER
	#include "PhysicsController.h"
#endif

#ifndef AI_CONTROLLER
	#include "AIController.h"
#endif

#ifndef GAME_WEAPON
	#include "GameWeapon.h"
#endif

#ifndef GAME_PLAYER
	#include "GamePlayer.h"
#endif

#ifndef GAME_SPRITE
	#include "GameSprite.h"
#endif

#ifndef GAME_ENEMY
	#include "GameEnemy.h"
#endif

#ifndef CONFIGURATION_DIALOG
	#include "ConfigurationDialog.h"
#endif

#ifndef GAME_SOUND
	#include "GameSound.h"
#endif

#ifndef GAME_SONG
	#include "GameSong.h"
#endif


#define GAME_APP

class GameApp
{
	protected:
		Boolean	done;			// Is the game over?
		Boolean gameInProgress;
        Boolean usingHID;
		GameContextPtr context;
		GameLevelPtr currentLevel;
		GameTileListPtr currentTileList;
		//GameOffscreenBufferPtr offscreenBuffer;
		BlitterPtr gameBlitter;
		WindowPtr screenWindow;		// The full screen window we use for drawing
		Ptr quickTimeStateData;     // Used for going into full screen mode
		
        GamePlayerPtr player1;
        InputControllerPtr player1InputController;
        AnimationControllerPtr player1AnimationController;
        PhysicsControllerPtr player1PhysicsController;
        AIControllerPtr enemyAIController;

		GameSongPtr backgroundMusic;
		GameSoundPtr soundEffect;
        
        Boolean screenScrolled;
        ConfigurationDialogPtr configureControlsDialog;
        
        double timeStep;
        double previousTime;
        
        LinkedList missileList;
        LinkedList enemyList;
        LinkedList itemList;
       
        GameWeapon weaponList[kTotalNumberOfWeapons];
                        
	public:
		GameApp (void);
		virtual ~GameApp(void);
		void InitApp(void);
		void EventLoop(void);
		void CleanUpApp(void);

		
	protected:
		// Initialization functions
		void LoadLevel(short levelID);
		void InitializeScreenWindow(void);
		void InitializeDrawContext(void);
		void InitializeGameBlitter(void);
		void InitializePlayer(void);
		void InitializeInputController(void);
		void InitializeSound(void);
		void InitializeWeapons(void);
		void InitializeEnemies(short enemyID);
        Boolean ReadPlayerStartingPosition(void);
        Boolean ReadLevelPopulation(short populationID);//, GameWeaponPtr weaponList,
        		//GameContextPtr theDrawContext);	
		void InitToolbox (void);
		void InitAppleEventHandlers (void);
		void SetUpMenuBar(void);
		
		// event related functions
		virtual void HandleIdleEvent(void);
		virtual void HandleEvent (EventRecord* event);
		virtual void HandleMouseDown(EventRecord* event);
		virtual void HandleMouseUp(EventRecord* event);
		virtual void CheckForCommandKey (EventRecord* event);
		//virtual void HandleActivate (EventRecord* event);
		virtual void HandleUpdate (EventRecord* event);
		virtual void HandleDiskEvent (EventRecord* event);
		virtual void HandleOSEvent(EventRecord* event);
		virtual void HandleMouseMoved(EventRecord* event);
		virtual void HandleSuspendResume(EventRecord* event);
		virtual void HandleHighLevelEvent(EventRecord* event);
		static OSErr GotRequiredAEParameters(const AppleEvent* theAppleEvent);
		static pascal OSErr HandleQuitApplication(const AppleEvent* theAppleEvent, 
                AppleEvent *theReply, long userData); 
		
		// menu related functions
		virtual void AdjustMenus(void);
		virtual void AdjustApplicationMenu(void);
		virtual void AdjustFileMenu(void);
		//virtual void AdjustEditMenu(void);
		virtual void AdjustOptionsMenu(void);
		virtual void HandleMenuCommand(long menuResult);
		void HandleAppleCommand (int menuItem);
		void DisplayAboutBox (short resourceID);
		virtual void HandleFileCommand (int menuItem);
		//virtual void HandleEditCommand (int menuItem);
		virtual void HandleOptionsCommand (int menuItem);
		virtual void ConfigureControls(void);
		virtual void Quit(void);
		void ChangeResumeMenuItemText();
		
		// Game related functions
		void GameLoop(void);
        Boolean CheckForEscapeKey(void);
		InputControllerAction ReadKeyboard(void);
		void AnimatePlayer(InputControllerAction playerAction);
		void AnimateEnemies(void);
		void MoveEnemy(GameEnemyPtr enemy, InputControllerAction theAction);
		void AnimateMissiles(void);
		void MoveMissile(GameWeaponPtr theMissile);
		void CollisionDetection(void);
        void PlayMusic(void);
        void ScrollBackground(void);
		void RenderFrame(void);
        void RenderScreen(void);
        void RenderDirtyRectangles(void);
        void DrawMissilesOffscreen(void);
        void DrawMissilesToScreen(void);
        void DrawMissileOnScreen(GameWeaponPtr missileToDraw);
        void DrawEnemiesOffscreen(void);
        void DrawEnemiesToScreen(void);
        void DrawEnemyOnScreen(GameEnemyPtr enemyToDraw);
        void DrawPlayerOffscreen(void);
        void DrawPlayerToScreen(void);
        void Pause(void);
		void StopFullScreen(void);
		void Resume(void);
		void StartFullScreen(void);
		
		// clean up functions
		void RemoveAppleEventHandlers(void);

		// Missile list functions
		void LaunchMissile(GameSpritePtr attacker, GameWeaponPtr attackingWeapon);
		short DetermineMissileStartX(GameSpritePtr attacker);
		short DetermineMissileStartY(GameSpritePtr attacker);
		void LaunchBolt(short startX, short startY, SpriteDirection missileDirection);
		//void LaunchBolt(double startX, double startY, SpriteDirection missileDirection);
		void KillMissile(GameWeaponPtr theMissile);
		void DeleteMissileList(void);

		// Enemy list functions
        void AddEnemyToList(LevelResidentPtr enemyToAdd, GameWeaponPtr weaponList,
        		GameContextPtr theDrawContext);
        void RemoveEnemyFromList(GameEnemyPtr enemyToRemove);
        void DeleteEnemyList();

		// Item list functions
        void AddItemToList(LevelResidentPtr itemToAdd, GameContextPtr theDrawContext);
        void RemoveItemFromList(GameItemPtr itemToRemove);
        void DeleteItemList();

		// Weapon List functions
		void FillWeaponList(void);

        // Enemy notification functions
        void NotifyEnemiesOfIntruders(void);
        void NotifyEnemiesOfAttack(short missileX, short missileY);
        
        // Creation functions
        GameWeaponPtr CreateWeapon(void);

        // Utility functions
        short GetCurrentColorDepth(void);
        Vector2D CalculatePlayerForce(void);
        double CalculateTimeStep(void);
        double ConvertMicrosecondsToDouble(UnsignedWidePtr microsecondsValue);        
		Boolean IsResidentAnEnemy(LevelResidentPtr residentToTest);

};	

typedef GameApp* GameAppPtr;
typedef GameApp** GameAppHandle;

// Non-member functions
void SetMenuAbility(MenuHandle menu, short menuItem, Boolean enabling);
Boolean WasKeyPressed(short keyCode, KeyMap theKeyboard);

// constants
const short kOneTile = 1;
const int kSleepValue = 32767;
const short kPictureResourceID = 128;
const short kWindowResourceID = 128;
const short kAboutBoxID = 130;	
const short kBackgroundMusicID = 8200;
const short kScreamSoundID = 8201;

// constants for the menus and menu items

const short kMenuBarID = 128;

const short kAppleMenu = 128;
const short kAbout		= 1;

const short kFileMenu = 129;
// elements 2 is a line separator
const short kResume = 	1;
const short	kQuit = 	3;		
const short kResumeTextID = 128;

const short kOptionsMenu = 131;
const short kConfigureMenuItem = 1;

// Keyboard constants
const short kLeftArrow = 0x7B;
const short kRightArrow = 0x7C;
const short kDownArrow = 0x7D;
const short kUpArrow = 0x7E;
const short kEscapeKey = 0x35;
const short kSpaceBar = 0x31;
const short kQuitKey = 0x0C00;

const char kLetterQ = 'q';
const Boolean kUseVirtualKeyCode = true;
const Boolean kDontUseVirtualKeyCode = false;

// Miscellaneous constants
const short kEightTiles = 8;
