// FiniteStateMachine.h		by Mark Szymczyk

#ifndef __CARBON__
    #include <Carbon/Carbon.h>
#endif

#ifndef FINITE_STATE
    #include "FiniteState.h"
#endif

#define FINITE_STATE_MACHINE

class FiniteStateMachine
{
	public:
		FiniteStatePtr stateTable;
    
    protected:
		short stateTotal;
		short currentStateIndex;		// The index of the entry in the state table
        
    public:
        // Constructor and destructor
        FiniteStateMachine(void);
		FiniteStateMachine(const FiniteStateMachine& theMachine);	// Copy constructor
        virtual ~FiniteStateMachine(void);

		// Overload assignment operator
		FiniteStateMachine& operator= (const FiniteStateMachine& theMachine);
        
        // Accessors
        short GetStateTotal(void);
        void SetStateTotal(short theTotal);
        
        short GetCurrentStateIndex(void);
        void SetCurrentStateIndex(short theIndex);
        
        // Filling the machine with states
        void FillStateTable(FiniteStatePtr tableToAdd);
        void AddState(FiniteStatePtr stateToAdd, short index);
    
        // Handling transitions
        void HandleStateTransition(StateTransitionType theTransition);

        // Utility functions
        short GetIndexFromState(StateType theState);
        
};

typedef FiniteStateMachine* FiniteStateMachinePtr;
typedef FiniteStateMachine** FiniteStateMachineHandle;
